/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.api.creativetab;

import com.hypherionmc.craterlib.core.systems.internal.CreativeTabRegistry;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;

public class CraterCreativeModeTab
implements Supplier<CreativeModeTab> {
    private final ResourceLocation resourceLocation;
    private final Supplier<ItemStack> icon;
    private final String backgroundSuffix;
    private CreativeModeTab tab;
    private final ResourceKey<CreativeModeTab> resourceKey;

    protected CraterCreativeModeTab(Builder builder) {
        this.resourceLocation = builder.location;
        this.icon = builder.stack;
        this.backgroundSuffix = builder.backgroundSuffix == null ? "" : builder.backgroundSuffix;
        this.resourceKey = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)this.resourceLocation);
        CreativeTabRegistry.registerTab(this);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public Supplier<ItemStack> getIcon() {
        return this.icon;
    }

    public String getBackgroundSuffix() {
        return this.backgroundSuffix;
    }

    public void setTab(CreativeModeTab tab) {
        this.tab = tab;
    }

    public ResourceKey<CreativeModeTab> getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public CreativeModeTab get() {
        return this.tab == null ? CreativeModeTabs.m_257543_() : this.tab;
    }

    public static class Builder {
        private final ResourceLocation location;
        private Supplier<ItemStack> stack;
        private String backgroundSuffix;

        public Builder(ResourceLocation location) {
            this.location = location;
        }

        public Builder setIcon(Supplier<ItemStack> icon) {
            this.stack = icon;
            return this;
        }

        public Builder backgroundSuffix(String backgroundSuffix) {
            this.backgroundSuffix = backgroundSuffix;
            return this;
        }

        public CraterCreativeModeTab build() {
            return new CraterCreativeModeTab(this);
        }
    }
}

