/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.network.message;

import dev.ghen.thirst.foundation.network.message.ClientThirstSyncMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PlayerThirstSyncMessage {
    public int thirst;
    public int quenched;
    public float exhaustion;

    public PlayerThirstSyncMessage(int thirst, int quenched, float exhaustion) {
        this.thirst = thirst;
        this.quenched = quenched;
        this.exhaustion = exhaustion;
    }

    public static void encode(PlayerThirstSyncMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.thirst);
        buffer.writeInt(message.quenched);
        buffer.writeFloat(message.exhaustion);
    }

    public static PlayerThirstSyncMessage decode(FriendlyByteBuf buffer) {
        return new PlayerThirstSyncMessage(buffer.readInt(), buffer.readInt(), buffer.readFloat());
    }

    public static void handle(PlayerThirstSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PlayerThirstSyncMessage.lambda$handle$1(message, (Supplier)contextSupplier)));
        }
        context.setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$1(PlayerThirstSyncMessage message, Supplier contextSupplier) {
        return () -> PlayerThirstSyncMessage.lambda$handle$0(message, (Supplier)contextSupplier);
    }

    private static /* synthetic */ void lambda$handle$0(PlayerThirstSyncMessage message, Supplier contextSupplier) {
        ClientThirstSyncMessage.handlePacket(message, contextSupplier);
    }
}

