/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.thirst.foundation.mixin.create;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FillingBySpout.class}, remap=false)
public class MixinFillingBySpout {
    @Final
    @Shadow
    private static RecipeWrapper WRAPPER;

    @Inject(method={"fillItem"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void fillItem(Level world, int requiredAmount, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<ItemStack> cir) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        WRAPPER.m_6836_(0, stack);
        if (WaterPurity.hasPurity(availableFluid)) {
            int purity = WaterPurity.getPurity(availableFluid);
            FillingRecipe fillingRecipe = SequencedAssemblyRecipe.getRecipe((Level)world, (Container)WRAPPER, (RecipeType)AllRecipeTypes.FILLING.getType(), FillingRecipe.class).filter(fr -> fr.getRequiredFluid().test(toFill)).orElseGet(() -> {
                Recipe recipe;
                FillingRecipe fr;
                FluidIngredient requiredFluid;
                Iterator var2 = world.m_7465_().m_44056_(AllRecipeTypes.FILLING.getType(), (Container)WRAPPER, world).iterator();
                do {
                    if (var2.hasNext()) continue;
                    return null;
                } while (!(requiredFluid = (fr = (FillingRecipe)(recipe = (Recipe)var2.next())).getRequiredFluid()).test(toFill));
                return fr;
            });
            if (fillingRecipe != null) {
                List results = fillingRecipe.rollResults();
                availableFluid.shrink(requiredAmount);
                stack.m_41774_(1);
                cir.setReturnValue((Object)(results.isEmpty() ? ItemStack.f_41583_ : (WaterPurity.isWaterFilledContainer((ItemStack)results.get(0)) ? WaterPurity.addPurity((ItemStack)results.get(0), purity) : (ItemStack)results.get(0))));
            } else {
                ItemStack output = GenericItemFilling.fillItem((Level)world, (int)requiredAmount, (ItemStack)stack, (FluidStack)availableFluid);
                cir.setReturnValue((Object)output);
            }
        }
    }
}

