/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.taxfreelevels.forge;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinConfig
implements IMixinConfigPlugin {
    private final Set<String> disabledMixins = new HashSet<String>();

    public static boolean isModInstalled(String modId) {
        if (FMLLoader.getLoadingModList() != null) {
            for (ModInfo mod : FMLLoader.getLoadingModList().getMods()) {
                if (!mod.getModId().equals(modId)) continue;
                return true;
            }
        }
        return false;
    }

    public void onLoad(String mixinPackage) {
        if (MixinConfig.isModInstalled("enchanting_overhauled")) {
            this.disabledMixins.add("CheapAnvilRenameMixin");
            this.disabledMixins.add("FlattenAnvilCostMixin");
        }
        if (!MixinConfig.isModInstalled("waystones")) {
            this.disabledMixins.add("WaystonesMixin");
        }
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixinName = mixinClassName.substring(mixinClassName.lastIndexOf(".mixin.forge") + ".mixin.forge".length() + 1);
        return !this.disabledMixins.contains(mixinName);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

