/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileUtils {
    public static void mkdirs(Path path) throws IOException {
        File file = path.toFile();
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("Cannot create directory because file exists at " + path);
            }
        } else {
            file.mkdirs();
            if (!file.exists() || !file.isDirectory()) {
                throw new IOException("Failed to create directory at " + path);
            }
        }
    }

    public static void rmdir(Path path) throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)path.toFile());
    }

    public static void writeResourceToFile(String resourcePath, Path targetFile) throws IOException {
        String rawResource;
        try (InputStream in = FileUtils.class.getClassLoader().getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new FileNotFoundException("Unable to load resource " + resourcePath);
            }
            rawResource = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        }
        FileUtils.mkdirs(targetFile.getParent());
        Files.writeString(targetFile, (CharSequence)rawResource, new OpenOption[0]);
    }
}

