/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.utils.Executor;

class ExecutorImpl
implements Executor {
    private ThreadPoolExecutor executor = null;
    private Future<?> exclusiveFuture = null;

    ExecutorImpl() {
    }

    @Override
    public void execute(Executor.ExecutionLock lock, UserLogger ulog, Runnable runnable) {
        Objects.requireNonNull(lock, "lock");
        if (this.executor == null) {
            throw new IllegalStateException("Executor not started");
        }
        switch (lock) {
            case NONE: 
            case WRITE_CONFIG: {
                this.executor.submit(runnable);
                break;
            }
            case WRITE: {
                if (this.exclusiveFuture != null && !this.exclusiveFuture.isDone()) {
                    ulog.message(UserMessage.styledLocalized("fastback.chat.thread-busy", UserMessage.UserMessageStyle.ERROR, new Object[0]));
                    break;
                }
                SystemLogger.syslog().debug("executing " + runnable);
                this.exclusiveFuture = this.executor.submit(runnable);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public void start() {
        this.executor = new ThreadPoolExecutor(0, 3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void stop() {
        ExecutorImpl.shutdownExecutor(this.executor);
        this.executor = null;
    }

    private static void shutdownExecutor(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.MINUTES)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(5L, TimeUnit.MINUTES)) {
                    System.err.println("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

