/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.transport.ssh.jsch;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.pcal.fastback.shaded.com.jcraft.jsch.ConfigRepository;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.SshSessionFactory;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS;

public class OpenSshConfig
implements ConfigRepository {
    private OpenSshConfigFile configFile;

    public static OpenSshConfig get(FS fs) {
        File home = fs.userHome();
        if (home == null) {
            home = new File(".").getAbsoluteFile();
        }
        File config = new File(new File(home, ".ssh"), "config");
        return new OpenSshConfig(home, config);
    }

    public OpenSshConfig(File h, File cfg) {
        this.configFile = new OpenSshConfigFile(h, cfg, SshSessionFactory.getLocalUserName());
    }

    public Host lookup(String hostName) {
        OpenSshConfigFile.HostEntry entry = this.configFile.lookup(hostName, -1, null);
        return new Host(entry, hostName, this.configFile.getLocalUserName());
    }

    @Override
    public ConfigRepository.Config getConfig(String hostName) {
        Host host = this.lookup(hostName);
        return host.getConfig();
    }

    public String toString() {
        return "OpenSshConfig [configFile=" + this.configFile + ']';
    }

    public static class Host {
        String hostName;
        int port;
        File identityFile;
        String user;
        String preferredAuthentications;
        Boolean batchMode;
        String strictHostKeyChecking;
        int connectionAttempts;
        private OpenSshConfigFile.HostEntry entry;
        private ConfigRepository.Config config;
        private static final Map<String, String> KEY_MAP = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

        static {
            KEY_MAP.put("kex", "KexAlgorithms");
            KEY_MAP.put("server_host_key", "HostKeyAlgorithms");
            KEY_MAP.put("cipher.c2s", "Ciphers");
            KEY_MAP.put("cipher.s2c", "Ciphers");
            KEY_MAP.put("mac.c2s", "MACs");
            KEY_MAP.put("mac.s2c", "MACs");
            KEY_MAP.put("compression.s2c", "Compression");
            KEY_MAP.put("compression.c2s", "Compression");
            KEY_MAP.put("compression_level", "CompressionLevel");
            KEY_MAP.put("MaxAuthTries", "NumberOfPasswordPrompts");
        }

        private static String mapKey(String key) {
            String k = KEY_MAP.get(key);
            return k != null ? k : key;
        }

        public Host() {
        }

        Host(OpenSshConfigFile.HostEntry entry, String hostName, String localUserName) {
            this.entry = entry;
            this.complete(hostName, localUserName);
        }

        public String getStrictHostKeyChecking() {
            return this.strictHostKeyChecking;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public File getIdentityFile() {
            return this.identityFile;
        }

        public String getUser() {
            return this.user;
        }

        public String getPreferredAuthentications() {
            return this.preferredAuthentications;
        }

        public boolean isBatchMode() {
            return this.batchMode != null && this.batchMode != false;
        }

        public int getConnectionAttempts() {
            return this.connectionAttempts;
        }

        private void complete(String initialHostName, String localUserName) {
            List<String> identityFiles;
            this.hostName = this.entry.getValue("HostName");
            this.user = this.entry.getValue("User");
            this.port = OpenSshConfigFile.positive(this.entry.getValue("Port"));
            this.connectionAttempts = OpenSshConfigFile.positive(this.entry.getValue("ConnectionAttempts"));
            this.strictHostKeyChecking = this.entry.getValue("StrictHostKeyChecking");
            this.batchMode = OpenSshConfigFile.flag(this.entry.getValue("BatchMode"));
            this.preferredAuthentications = this.entry.getValue("PreferredAuthentications");
            if (this.hostName == null || this.hostName.isEmpty()) {
                this.hostName = initialHostName;
            }
            if (this.user == null || this.user.isEmpty()) {
                this.user = localUserName;
            }
            if (this.port <= 0) {
                this.port = 22;
            }
            if (this.connectionAttempts <= 0) {
                this.connectionAttempts = 1;
            }
            if ((identityFiles = this.entry.getValues("IdentityFile")) != null && !identityFiles.isEmpty()) {
                this.identityFile = new File(identityFiles.get(0));
            }
        }

        public ConfigRepository.Config getConfig() {
            if (this.config == null) {
                this.config = new ConfigRepository.Config(){

                    @Override
                    public String getHostname() {
                        return this.getHostName();
                    }

                    @Override
                    public String getUser() {
                        return this.getUser();
                    }

                    @Override
                    public int getPort() {
                        return this.getPort();
                    }

                    @Override
                    public String getValue(String key) {
                        if (key.equals("compression.s2c") || key.equals("compression.c2s")) {
                            if (!OpenSshConfigFile.flag(entry.getValue(Host.mapKey(key)))) {
                                return "none,zlib@openssh.com,zlib";
                            }
                            return "zlib@openssh.com,zlib,none";
                        }
                        return entry.getValue(Host.mapKey(key));
                    }

                    @Override
                    public String[] getValues(String key) {
                        List<String> values = entry.getValues(Host.mapKey(key));
                        if (values == null) {
                            return new String[0];
                        }
                        return values.toArray(new String[0]);
                    }
                };
            }
            return this.config;
        }

        public String toString() {
            return "Host [hostName=" + this.hostName + ", port=" + this.port + ", identityFile=" + this.identityFile + ", user=" + this.user + ", preferredAuthentications=" + this.preferredAuthentications + ", batchMode=" + this.batchMode + ", strictHostKeyChecking=" + this.strictHostKeyChecking + ", connectionAttempts=" + this.connectionAttempts + ", entry=" + this.entry + "]";
        }
    }
}

