/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.revwalk;

import java.io.IOException;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.MissingObjectException;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.BlockRevQueue;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.FIFORevQueue;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.Generator;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.RevCommit;

class TopoNonIntermixSortGenerator
extends Generator {
    private static final int TOPO_QUEUED = 64;
    private final FIFORevQueue pending;
    private final int outputType;

    TopoNonIntermixSortGenerator(Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        super(s.firstParent);
        RevCommit c;
        this.pending = new FIFORevQueue(this.firstParent);
        this.outputType = s.outputType() | 8;
        s.shareFreeList(this.pending);
        while ((c = s.next()) != null) {
            if ((c.flags & 0x40) == 0) {
                RevCommit[] revCommitArray = c.getParents();
                int n = revCommitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    RevCommit p = revCommitArray[n2];
                    ++p.inDegree;
                    if (this.firstParent) break;
                    ++n2;
                }
            }
            c.flags |= 0x40;
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.outputType;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        q.shareFreeList(this.pending);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        do {
            if ((c = this.pending.next()) != null) continue;
            return null;
        } while (c.inDegree > 0 || (c.flags & 0x40) == 0);
        RevCommit[] revCommitArray = c.getParents();
        int n = revCommitArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit p = revCommitArray[n2];
            if (--p.inDegree == 0 && (p.flags & 0x40) != 0) {
                this.pending.unpop(p);
            }
            if (this.firstParent) break;
            ++n2;
        }
        c.flags &= 0xFFFFFFBF;
        return c;
    }
}

