/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.lib;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.GpgSignatureVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GpgSignatureVerifierFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GpgSignatureVerifierFactory.class);

    public static GpgSignatureVerifierFactory getDefault() {
        return DefaultFactory.getDefault();
    }

    public static void setDefault(GpgSignatureVerifierFactory factory) {
        DefaultFactory.setDefault(factory);
    }

    public abstract GpgSignatureVerifier getVerifier();

    private static class DefaultFactory {
        private static volatile GpgSignatureVerifierFactory defaultFactory = DefaultFactory.loadDefault();

        private static GpgSignatureVerifierFactory loadDefault() {
            try {
                ServiceLoader<GpgSignatureVerifierFactory> loader = ServiceLoader.load(GpgSignatureVerifierFactory.class);
                Iterator<GpgSignatureVerifierFactory> iter = loader.iterator();
                if (iter.hasNext()) {
                    return iter.next();
                }
            }
            catch (ServiceConfigurationError e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }

        private DefaultFactory() {
        }

        public static GpgSignatureVerifierFactory getDefault() {
            return defaultFactory;
        }

        public static void setDefault(GpgSignatureVerifierFactory factory) {
            defaultFactory = factory;
        }
    }
}

