/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.file.LockFile;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Constants;
import net.pcal.fastback.shaded.org.eclipse.jgit.transport.PackLock;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FileUtils;

public class PackLockImpl
implements PackLock {
    private final File keepFile;

    public PackLockImpl(File packFile, FS fs) {
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, String.valueOf(n.substring(0, n.length() - 5)) + ".keep");
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!msg.endsWith("\n")) {
            msg = String.valueOf(msg) + "\n";
        }
        if (!(lf = new LockFile(this.keepFile)).lock()) {
            return false;
        }
        lf.write(Constants.encode(msg));
        return lf.commit();
    }

    @Override
    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

