/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.dfs;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.pack.PackExt;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Config;

public class DfsBlockCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    public static final int DEFAULT_CACHE_HOT_MAX = 1;
    private long blockLimit;
    private int blockSize;
    private double streamRatio;
    private int concurrencyLevel;
    private Consumer<Long> refLock;
    private Map<PackExt, Integer> cacheHotMap;
    private IndexEventConsumer indexEventConsumer;

    public DfsBlockCacheConfig() {
        this.setBlockLimit(0x2000000L);
        this.setBlockSize(65536);
        this.setStreamRatio(0.3);
        this.setConcurrencyLevel(32);
        this.cacheHotMap = Collections.emptyMap();
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public DfsBlockCacheConfig setBlockLimit(long newLimit) {
        if (newLimit <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotPositive, newLimit));
        }
        this.blockLimit = newLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DfsBlockCacheConfig setBlockSize(int newSize) {
        int size = Math.max(512, newSize);
        if ((size & size - 1) != 0) {
            throw new IllegalArgumentException(JGitText.get().blockSizeNotPowerOf2);
        }
        this.blockSize = size;
        return this;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public DfsBlockCacheConfig setConcurrencyLevel(int newConcurrencyLevel) {
        this.concurrencyLevel = newConcurrencyLevel;
        return this;
    }

    public double getStreamRatio() {
        return this.streamRatio;
    }

    public DfsBlockCacheConfig setStreamRatio(double ratio) {
        this.streamRatio = Math.max(0.0, Math.min(ratio, 1.0));
        return this;
    }

    public Consumer<Long> getRefLockWaitTimeConsumer() {
        return this.refLock;
    }

    public DfsBlockCacheConfig setRefLockWaitTimeConsumer(Consumer<Long> c) {
        this.refLock = c;
        return this;
    }

    public Map<PackExt, Integer> getCacheHotMap() {
        return this.cacheHotMap;
    }

    public DfsBlockCacheConfig setCacheHotMap(Map<PackExt, Integer> cacheHotMap) {
        this.cacheHotMap = Collections.unmodifiableMap(cacheHotMap);
        return this;
    }

    public IndexEventConsumer getIndexEventConsumer() {
        return this.indexEventConsumer;
    }

    public DfsBlockCacheConfig setIndexEventConsumer(IndexEventConsumer indexEventConsumer) {
        this.indexEventConsumer = indexEventConsumer;
        return this;
    }

    public DfsBlockCacheConfig fromConfig(Config rc) {
        int cfgBlockSize;
        long cfgBlockLimit = rc.getLong("core", "dfs", "blockLimit", this.getBlockLimit());
        if (cfgBlockLimit % (long)(cfgBlockSize = rc.getInt("core", "dfs", "blockSize", this.getBlockSize())) != 0L) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().blockLimitNotMultipleOfBlockSize, cfgBlockLimit, cfgBlockSize));
        }
        this.setBlockLimit(cfgBlockLimit);
        this.setBlockSize(cfgBlockSize);
        this.setConcurrencyLevel(rc.getInt("core", "dfs", "concurrencyLevel", this.getConcurrencyLevel()));
        String v = rc.getString("core", "dfs", "streamRatio");
        if (v != null) {
            try {
                this.setStreamRatio(Double.parseDouble(v));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, "core", "dfs", "streamRatio", v), e);
            }
        }
        return this;
    }

    public static interface IndexEventConsumer {
        public void acceptRequestedEvent(int var1, boolean var2, long var3, long var5, Duration var7);

        default public void acceptEvictedEvent(int packExtPos, long bytes, int totalCacheHitCount, Duration lastEvictionDuration) {
        }

        default public boolean shouldReportEvictedEvent() {
            return false;
        }
    }
}

