/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.commitgraph;

import java.text.MessageFormat;
import java.util.Arrays;
import net.pcal.fastback.shaded.org.eclipse.jgit.annotations.NonNull;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.NB;

class GraphCommitData {
    private static final int[] NO_PARENTS = new int[0];
    private final byte[] data;
    private final byte[] extraList;
    private final int hashLength;
    private final int commitDataLength;

    GraphCommitData(int hashLength, @NonNull byte[] commitData, byte[] extraList) {
        this.data = commitData;
        this.extraList = extraList;
        this.hashLength = hashLength;
        this.commitDataLength = hashLength + 16;
    }

    CommitGraph.CommitData getCommitData(int graphPos) {
        int dataIdx = this.commitDataLength * graphPos;
        ObjectId tree = ObjectId.fromRaw(this.data, dataIdx);
        long dateHigh = NB.decodeUInt32(this.data, dataIdx + this.hashLength + 8) & 3L;
        long dateLow = NB.decodeUInt32(this.data, dataIdx + this.hashLength + 12);
        long commitTime = dateHigh << 32 | dateLow;
        int generation = NB.decodeInt32(this.data, dataIdx + this.hashLength + 8) >> 2;
        int parent1 = NB.decodeInt32(this.data, dataIdx + this.hashLength);
        if (parent1 == 0x70000000) {
            return new CommitDataImpl(tree, NO_PARENTS, commitTime, generation);
        }
        int parent2 = NB.decodeInt32(this.data, dataIdx + this.hashLength + 4);
        if (parent2 == 0x70000000) {
            return new CommitDataImpl(tree, new int[]{parent1}, commitTime, generation);
        }
        if ((parent2 & Integer.MIN_VALUE) == 0) {
            return new CommitDataImpl(tree, new int[]{parent1, parent2}, commitTime, generation);
        }
        return new CommitDataImpl(tree, this.findParentsForOctopusMerge(parent1, parent2 & Integer.MAX_VALUE), commitTime, generation);
    }

    private int[] findParentsForOctopusMerge(int parent1, int extraEdgePos) {
        int maxOffset = this.extraList.length - 4;
        int offset = extraEdgePos * 4;
        if (offset < 0 || offset > maxOffset) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidExtraEdgeListPosition, extraEdgePos));
        }
        int[] pList = new int[32];
        pList[0] = parent1;
        int count = 1;
        while (offset <= maxOffset) {
            int parentPosition;
            if (count >= pList.length) {
                pList = Arrays.copyOf(pList, pList.length + 32);
            }
            if (((parentPosition = NB.decodeInt32(this.extraList, offset)) & Integer.MIN_VALUE) != 0) {
                pList[count++] = parentPosition & Integer.MAX_VALUE;
                break;
            }
            pList[count++] = parentPosition;
            offset += 4;
        }
        return Arrays.copyOf(pList, count);
    }

    private static class CommitDataImpl
    implements CommitGraph.CommitData {
        private final ObjectId tree;
        private final int[] parents;
        private final long commitTime;
        private final int generation;

        public CommitDataImpl(ObjectId tree, int[] parents, long commitTime, int generation) {
            this.tree = tree;
            this.parents = parents;
            this.commitTime = commitTime;
            this.generation = generation;
        }

        @Override
        public ObjectId getTree() {
            return this.tree;
        }

        @Override
        public int[] getParents() {
            return this.parents;
        }

        @Override
        public long getCommitTime() {
            return this.commitTime;
        }

        @Override
        public int getGeneration() {
            return this.generation;
        }
    }
}

