/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool;

import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolException
extends Exception {
    private static final Logger LOG = LoggerFactory.getLogger(ToolException.class);
    private final FS.ExecutionResult result;
    private final boolean commandExecutionError;
    private static final long serialVersionUID = 1L;

    public ToolException() {
        this(null, null, false);
    }

    public ToolException(String message) {
        this(message, null, false);
    }

    public ToolException(String message, FS.ExecutionResult result, boolean commandExecutionError) {
        super(message);
        this.result = result;
        this.commandExecutionError = commandExecutionError;
    }

    public ToolException(String message, Throwable cause) {
        super(message, cause);
        this.result = null;
        this.commandExecutionError = false;
    }

    public ToolException(Throwable cause) {
        super(cause);
        this.result = null;
        this.commandExecutionError = false;
    }

    public boolean isResult() {
        return this.result != null;
    }

    public FS.ExecutionResult getResult() {
        return this.result;
    }

    public boolean isCommandExecutionError() {
        return this.commandExecutionError;
    }

    public String getResultStderr() {
        if (this.result == null) {
            return "";
        }
        try {
            return new String(this.result.getStderr().toByteArray(), SystemReader.getInstance().getDefaultCharset());
        }
        catch (Exception e) {
            LOG.warn("Failed to retrieve standard error output", (Throwable)e);
            return "";
        }
    }

    public String getResultStdout() {
        if (this.result == null) {
            return "";
        }
        try {
            return new String(this.result.getStdout().toByteArray(), SystemReader.getInstance().getDefaultCharset());
        }
        catch (Exception e) {
            LOG.warn("Failed to retrieve standard output", (Throwable)e);
            return "";
        }
    }
}

