/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import net.pcal.fastback.shaded.org.eclipse.jgit.attributes.Attributes;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.RevisionSyntaxException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.CommandExecutor;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.FileElement;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.diffmergetool.ToolException;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.FileTreeIterator;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.NotIgnoredFilter;
import net.pcal.fastback.shaded.org.eclipse.jgit.util.FS;

public class ExternalToolUtils {
    public static final String KEY_MERGE_TOOL = "mergetool";
    public static final String KEY_DIFF_TOOL = "difftool";

    public static String prepareCommand(String command, FileElement localFile, FileElement remoteFile, FileElement mergedFile, FileElement baseFile) throws IOException {
        if (localFile != null) {
            command = localFile.replaceVariable(command);
        }
        if (remoteFile != null) {
            command = remoteFile.replaceVariable(command);
        }
        if (mergedFile != null) {
            command = mergedFile.replaceVariable(command);
        }
        if (baseFile != null) {
            command = baseFile.replaceVariable(command);
        }
        return command;
    }

    public static Map<String, String> prepareEnvironment(File gitDir, FileElement localFile, FileElement remoteFile, FileElement mergedFile, FileElement baseFile) throws IOException {
        TreeMap<String, String> env = new TreeMap<String, String>();
        if (gitDir != null) {
            env.put("GIT_DIR", gitDir.getAbsolutePath());
        }
        if (localFile != null) {
            localFile.addToEnv(env);
        }
        if (remoteFile != null) {
            remoteFile.addToEnv(env);
        }
        if (mergedFile != null) {
            mergedFile.addToEnv(env);
        }
        if (baseFile != null) {
            baseFile.addToEnv(env);
        }
        return env;
    }

    public static String quotePath(String path) {
        if (path.contains(" ")) {
            if (!path.startsWith("\"")) {
                path = "\"" + path;
            }
            if (!path.endsWith("\"")) {
                path = String.valueOf(path) + "\"";
            }
        }
        return path;
    }

    public static boolean isToolAvailable(FS fs, File gitDir, File directory, String path) {
        boolean available = true;
        try {
            CommandExecutor cmdExec = new CommandExecutor(fs, false);
            available = cmdExec.checkExecutable(path, directory, ExternalToolUtils.prepareEnvironment(gitDir, null, null, null, null));
        }
        catch (Exception e) {
            available = false;
        }
        return available;
    }

    public static Set<String> createSortedToolSet(String defaultName, Set<String> userDefinedNames, Set<String> preDefinedNames) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (defaultName != null) {
            LinkedHashSet<String> namesPredef = new LinkedHashSet<String>();
            LinkedHashSet<String> namesUser = new LinkedHashSet<String>();
            namesUser.addAll(userDefinedNames);
            namesUser.remove(defaultName);
            namesPredef.addAll(preDefinedNames);
            namesPredef.remove(defaultName);
            names.add(defaultName);
            names.addAll(namesUser);
            names.addAll(namesPredef);
        } else {
            names.addAll(userDefinedNames);
            names.addAll(preDefinedNames);
        }
        return names;
    }

    public static Optional<String> getExternalToolFromAttributes(Repository repository, String path, String toolKey) throws ToolException {
        try {
            FileTreeIterator treeIterator = new FileTreeIterator(repository);
            Throwable throwable = null;
            Object var5_7 = null;
            try (TreeWalk walk = new TreeWalk(repository);){
                walk.addTree(treeIterator);
                walk.setFilter(new NotIgnoredFilter(0));
                while (walk.next()) {
                    Attributes attrs;
                    String treePath = walk.getPathString();
                    if (treePath.equals(path) && (attrs = walk.getAttributes()).containsKey(toolKey)) {
                        return Optional.of(attrs.getValue(toolKey));
                    }
                    if (!walk.isSubtree()) continue;
                    walk.enterSubtree();
                }
                return Optional.empty();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RevisionSyntaxException e) {
            throw new ToolException(e);
        }
    }
}

