/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.ignore.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.pcal.fastback.shaded.org.eclipse.jgit.errors.InvalidPatternException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;

public class Strings {
    static final List<String> POSIX_CHAR_CLASSES = Arrays.asList("alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit", "word");
    private static final String DL = "\\p{javaDigit}\\p{javaLetter}";
    static final List<String> JAVA_CHAR_CLASSES = Arrays.asList("\\p{Alnum}", "\\p{javaLetter}", "\\p{Blank}", "\\p{Cntrl}", "\\p{javaDigit}", "[\\p{Graph}\\p{javaDigit}\\p{javaLetter}]", "\\p{Ll}", "[\\p{Print}\\p{javaDigit}\\p{javaLetter}]", "\\p{Punct}", "\\p{Space}", "\\p{Lu}", "\\p{XDigit}", "[\\p{javaDigit}\\p{javaLetter}_]");
    static final Pattern UNSUPPORTED = Pattern.compile("\\[\\[[.=]\\w+[.=]\\]\\]");

    static char getPathSeparator(Character pathSeparator) {
        return pathSeparator == null ? (char)'/' : (char)pathSeparator.charValue();
    }

    public static String stripTrailing(String pattern, char c) {
        int i = pattern.length() - 1;
        while (i >= 0) {
            char charAt = pattern.charAt(i);
            if (charAt != c) {
                if (i == pattern.length() - 1) {
                    return pattern;
                }
                return pattern.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static String stripTrailingWhitespace(String pattern) {
        int i = pattern.length() - 1;
        while (i >= 0) {
            char charAt = pattern.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                if (i == pattern.length() - 1) {
                    return pattern;
                }
                return pattern.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static boolean isDirectoryPattern(String pattern) {
        int i = pattern.length() - 1;
        while (i >= 0) {
            char charAt = pattern.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                return charAt == '/';
            }
            --i;
        }
        return false;
    }

    static int count(String s, char c, boolean ignoreFirstLast) {
        int start = 0;
        int count = 0;
        int length = s.length();
        while (start < length) {
            if ((start = s.indexOf(c, start)) == -1) break;
            if (!ignoreFirstLast || start != 0 && start != length - 1) {
                ++count;
            }
            ++start;
        }
        return count;
    }

    public static List<String> split(String pattern, char slash) {
        int count = Strings.count(pattern, slash, true);
        if (count < 1) {
            throw new IllegalStateException("Pattern must have at least two segments: " + pattern);
        }
        ArrayList<String> segments = new ArrayList<String>(count);
        int right = 0;
        while (true) {
            int left = ++right;
            if ((right = pattern.indexOf(slash, right)) == -1) {
                if (left >= pattern.length()) break;
                segments.add(pattern.substring(left));
                break;
            }
            if (right - left <= 0) continue;
            if (left == 1) {
                segments.add(pattern.substring(left - 1, right));
                continue;
            }
            if (right == pattern.length() - 1) {
                segments.add(pattern.substring(left, right + 1));
                continue;
            }
            segments.add(pattern.substring(left, right));
        }
        return segments;
    }

    static boolean isWildCard(String pattern) {
        return pattern.indexOf(42) != -1 || Strings.isComplexWildcard(pattern);
    }

    private static boolean isComplexWildcard(String pattern) {
        int idx1 = pattern.indexOf(91);
        if (idx1 != -1) {
            return true;
        }
        if (pattern.indexOf(63) != -1) {
            return true;
        }
        int backSlash = pattern.indexOf(92);
        if (backSlash >= 0) {
            int nextIdx = backSlash + 1;
            if (pattern.length() == nextIdx) {
                return false;
            }
            char nextChar = pattern.charAt(nextIdx);
            return Strings.escapedByBackslash(nextChar);
        }
        return false;
    }

    private static boolean escapedByBackslash(char nextChar) {
        return nextChar == '?' || nextChar == '*' || nextChar == '[';
    }

    static PatternState checkWildCards(String pattern) {
        if (Strings.isComplexWildcard(pattern)) {
            return PatternState.COMPLEX;
        }
        int startIdx = pattern.indexOf(42);
        if (startIdx < 0) {
            return PatternState.NONE;
        }
        if (startIdx == pattern.length() - 1) {
            return PatternState.TRAILING_ASTERISK_ONLY;
        }
        if (pattern.lastIndexOf(42) == 0) {
            return PatternState.LEADING_ASTERISK_ONLY;
        }
        return PatternState.COMPLEX;
    }

    static Pattern convertGlob(String pattern) throws InvalidPatternException {
        if (UNSUPPORTED.matcher(pattern).find()) {
            throw new InvalidPatternException("Collating symbols [[.a.]] or equivalence class expressions [[=a=]] are not supported", pattern);
        }
        StringBuilder sb = new StringBuilder(pattern.length());
        int in_brackets = 0;
        boolean seenEscape = false;
        boolean ignoreLastBracket = false;
        boolean in_char_class = false;
        char[] charClass = new char[6];
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('.').append(c);
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('\\').append(c);
                    break;
                }
                case '.': {
                    if (seenEscape) {
                        sb.append(c);
                        break;
                    }
                    sb.append('\\').append('.');
                    break;
                }
                case '?': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('.');
                    break;
                }
                case ':': {
                    if (in_brackets > 0 && Strings.lookBehind(sb) == '[' && Character.isLetter(Strings.lookAhead(pattern, i))) {
                        in_char_class = true;
                    }
                    sb.append(':');
                    break;
                }
                case '-': {
                    if (in_brackets > 0) {
                        if (Strings.lookAhead(pattern, i) == ']') {
                            sb.append('\\').append(c);
                            break;
                        }
                        sb.append(c);
                        break;
                    }
                    sb.append('-');
                    break;
                }
                case '\\': {
                    char lookAhead;
                    if (in_brackets > 0) {
                        lookAhead = Strings.lookAhead(pattern, i);
                        if (lookAhead == ']' || lookAhead == '[') {
                            ignoreLastBracket = true;
                        }
                    } else {
                        lookAhead = Strings.lookAhead(pattern, i);
                        if (lookAhead != '\\' && lookAhead != '[' && lookAhead != '?' && lookAhead != '*' && lookAhead != ' ' && Strings.lookBehind(sb) != '\\') break;
                    }
                    sb.append(c);
                    break;
                }
                case '[': {
                    if (in_brackets > 0) {
                        if (!seenEscape) {
                            sb.append('\\');
                        }
                        sb.append('[');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (!seenEscape) {
                        ++in_brackets;
                        ignoreLastBracket = false;
                    }
                    sb.append('[');
                    break;
                }
                case ']': {
                    if (seenEscape) {
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (in_brackets <= 0) {
                        sb.append('\\').append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    char lookBehind = Strings.lookBehind(sb);
                    if (lookBehind == '[' && !ignoreLastBracket || lookBehind == '^') {
                        sb.append('\\');
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    ignoreLastBracket = false;
                    if (!in_char_class) {
                        --in_brackets;
                        sb.append(']');
                        break;
                    }
                    in_char_class = false;
                    String charCl = Strings.checkPosixCharClass(charClass);
                    if (charCl != null) {
                        sb.setLength(sb.length() - 4);
                        sb.append(charCl);
                    }
                    Strings.reset(charClass);
                    break;
                }
                case '!': {
                    if (in_brackets > 0) {
                        if (Strings.lookBehind(sb) == '[') {
                            sb.append('^');
                            break;
                        }
                        sb.append(c);
                        break;
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    if (in_char_class) {
                        Strings.setNext(charClass, c);
                        break;
                    }
                    sb.append(c);
                }
            }
            seenEscape = c == '\\';
            ++i;
        }
        if (in_brackets > 0) {
            throw new InvalidPatternException("Not closed bracket?", pattern);
        }
        try {
            return Pattern.compile(sb.toString(), 32);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidPatternException(MessageFormat.format(JGitText.get().invalidIgnoreRule, pattern), pattern, e);
        }
    }

    private static char lookBehind(StringBuilder buffer) {
        return buffer.length() > 0 ? buffer.charAt(buffer.length() - 1) : (char)'\u0000';
    }

    private static char lookAhead(String pattern, int i) {
        int idx = i + 1;
        return idx >= pattern.length() ? (char)'\u0000' : pattern.charAt(idx);
    }

    private static void setNext(char[] buffer, char c) {
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] == '\u0000') {
                buffer[i] = c;
                break;
            }
            ++i;
        }
    }

    private static void reset(char[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = '\u0000';
            ++i;
        }
    }

    private static String checkPosixCharClass(char[] buffer) {
        int i = 0;
        while (i < POSIX_CHAR_CLASSES.size()) {
            String clazz = POSIX_CHAR_CLASSES.get(i);
            boolean match = true;
            int j = 0;
            while (j < clazz.length()) {
                if (buffer[j] != clazz.charAt(j)) {
                    match = false;
                    break;
                }
                ++j;
            }
            if (match) {
                return JAVA_CHAR_CLASSES.get(i);
            }
            ++i;
        }
        return null;
    }

    static String deleteBackslash(String s) {
        if (s.indexOf(92) < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            block6: {
                char ch;
                block5: {
                    char next;
                    block7: {
                        ch = s.charAt(i);
                        if (ch != '\\') break block5;
                        if (i + 1 == s.length()) break block6;
                        next = s.charAt(i + 1);
                        if (next != '\\') break block7;
                        sb.append(ch);
                        ++i;
                        break block6;
                    }
                    if (!Strings.escapedByBackslash(next)) break block6;
                }
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    static enum PatternState {
        LEADING_ASTERISK_ONLY,
        TRAILING_ASTERISK_ONLY,
        COMPLEX,
        NONE;

    }
}

