/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.attributes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.pcal.fastback.shaded.org.eclipse.jgit.attributes.Attribute;

public final class Attributes {
    private final Map<String, Attribute> map = new LinkedHashMap<String, Attribute>();

    public Attributes(Attribute ... attributes) {
        if (attributes != null) {
            Attribute[] attributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute a = attributeArray[n2];
                this.put(a);
                ++n2;
            }
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Attribute get(String key) {
        return this.map.get(key);
    }

    public Collection<Attribute> getAll() {
        return new ArrayList<Attribute>(this.map.values());
    }

    public void put(Attribute a) {
        this.map.put(a.getKey(), a);
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public Attribute.State getState(String key) {
        Attribute a = this.map.get(key);
        return a != null ? a.getState() : Attribute.State.UNSPECIFIED;
    }

    public boolean isSet(String key) {
        return this.getState(key) == Attribute.State.SET;
    }

    public boolean isUnset(String key) {
        return this.getState(key) == Attribute.State.UNSET;
    }

    public boolean isUnspecified(String key) {
        return this.getState(key) == Attribute.State.UNSPECIFIED;
    }

    public boolean isCustom(String key) {
        return this.getState(key) == Attribute.State.CUSTOM;
    }

    public String getValue(String key) {
        Attribute a = this.map.get(key);
        return a != null ? a.getValue() : null;
    }

    public boolean canBeContentMerged() {
        if (this.isUnset("merge")) {
            return false;
        }
        return !this.isCustom("merge") || !this.getValue("merge").equals("binary");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("[");
        buf.append(" ");
        for (Attribute a : this.map.values()) {
            buf.append(a.toString());
            buf.append(" ");
        }
        buf.append("]");
        return buf.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Attributes)) {
            return false;
        }
        Attributes other = (Attributes)obj;
        return this.map.equals(other.map);
    }
}

