/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.api;

import java.io.IOException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.GitCommand;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.NoHeadException;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.CommitBuilder;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectReader;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.PersonIdent;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Ref;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.RefUpdate;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.RevCommit;
import net.pcal.fastback.shaded.org.eclipse.jgit.revwalk.RevWalk;

public class StashCreateCommand
extends GitCommand<RevCommit> {
    private static final String MSG_INDEX = "index on {0}: {1} {2}";
    private static final String MSG_UNTRACKED = "untracked files on {0}: {1} {2}";
    private static final String MSG_WORKING_DIR = "WIP on {0}: {1} {2}";
    private String indexMessage = "index on {0}: {1} {2}";
    private String workingDirectoryMessage = "WIP on {0}: {1} {2}";
    private String ref = "refs/stash";
    private PersonIdent person;
    private boolean includeUntracked;

    public StashCreateCommand(Repository repo) {
        super(repo);
        this.person = new PersonIdent(repo);
    }

    public StashCreateCommand setIndexMessage(String message) {
        this.indexMessage = message;
        return this;
    }

    public StashCreateCommand setWorkingDirectoryMessage(String message) {
        this.workingDirectoryMessage = message;
        return this;
    }

    public StashCreateCommand setPerson(PersonIdent person) {
        this.person = person;
        return this;
    }

    public StashCreateCommand setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public StashCreateCommand setIncludeUntracked(boolean includeUntracked) {
        this.includeUntracked = includeUntracked;
        return this;
    }

    private RevCommit parseCommit(ObjectReader reader, ObjectId headId) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk walk = new RevWalk(reader);){
            return walk.parseCommit(headId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private CommitBuilder createBuilder() {
        CommitBuilder builder = new CommitBuilder();
        PersonIdent author = this.person;
        if (author == null) {
            author = new PersonIdent(this.repo);
        }
        builder.setAuthor(author);
        builder.setCommitter(author);
        return builder;
    }

    private void updateStashRef(ObjectId commitId, PersonIdent refLogIdent, String refLogMessage) throws IOException {
        if (this.ref == null) {
            return;
        }
        Ref currentRef = this.repo.findRef(this.ref);
        RefUpdate refUpdate = this.repo.updateRef(this.ref);
        refUpdate.setNewObjectId(commitId);
        refUpdate.setRefLogIdent(refLogIdent);
        refUpdate.setRefLogMessage(refLogMessage, false);
        refUpdate.setForceRefLog(true);
        if (currentRef != null) {
            refUpdate.setExpectedOldObjectId(currentRef.getObjectId());
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.forceUpdate();
    }

    private Ref getHead() throws GitAPIException {
        try {
            Ref head = this.repo.exactRef("HEAD");
            if (head == null || head.getObjectId() == null) {
                throw new NoHeadException(JGitText.get().headRequiredToStash);
            }
            return head;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().stashFailed, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public RevCommit call() throws GitAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 10 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

