/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.shaded.org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.GitCommand;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.FilterFailedException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.NoFilepatternException;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCache;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCacheBuildIterator;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCacheBuilder;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCacheEntry;
import net.pcal.fastback.shaded.org.eclipse.jgit.dircache.DirCacheIterator;
import net.pcal.fastback.shaded.org.eclipse.jgit.internal.JGitText;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.FileMode;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectId;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.ObjectInserter;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Repository;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.FileTreeIterator;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.WorkingTreeIterator;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import net.pcal.fastback.shaded.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class AddCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private WorkingTreeIterator workingTreeIterator;
    private boolean update = false;
    private boolean renormalize = true;

    public AddCommand(Repository repo) {
        super(repo);
    }

    public AddCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator f) {
        this.workingTreeIterator = f;
        return this;
    }

    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        boolean addAll = this.filepatterns.contains(".");
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    ObjectInserter inserter = this.repo.newObjectInserter();
                    try {
                        try (NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);){
                            tw.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
                            dc = this.repo.lockDirCache();
                            DirCacheBuilder builder = dc.builder();
                            tw.addTree(new DirCacheBuildIterator(builder));
                            if (this.workingTreeIterator == null) {
                                this.workingTreeIterator = new FileTreeIterator(this.repo);
                            }
                            this.workingTreeIterator.setDirCacheIterator(tw, 0);
                            tw.addTree(this.workingTreeIterator);
                            TreeFilter pathFilter = null;
                            if (!addAll) {
                                pathFilter = PathFilterGroup.createFromStrings(this.filepatterns);
                            }
                            if (!this.renormalize) {
                                if (pathFilter == null) {
                                    tw.setFilter(new IndexDiffFilter(0, 1));
                                } else {
                                    tw.setFilter(AndTreeFilter.create(new IndexDiffFilter(0, 1), pathFilter));
                                }
                            } else if (pathFilter != null) {
                                tw.setFilter(pathFilter);
                            }
                            byte[] lastAdded = null;
                            while (tw.next()) {
                                byte[] path;
                                DirCacheEntry entry;
                                block47: {
                                    DirCacheIterator c = tw.getTree(0, DirCacheIterator.class);
                                    WorkingTreeIterator f = tw.getTree(1, WorkingTreeIterator.class);
                                    if (c == null && f != null && f.isEntryIgnored() || c == null && this.update) continue;
                                    DirCacheEntry dirCacheEntry = entry = c != null ? c.getDirCacheEntry() : null;
                                    if (entry != null && entry.getStage() > 0 && lastAdded != null && lastAdded.length == tw.getPathLength() && tw.isPathPrefix(lastAdded, lastAdded.length) == 0) continue;
                                    if (tw.isSubtree() && !tw.isDirectoryFileConflict()) {
                                        tw.enterSubtree();
                                        continue;
                                    }
                                    if (f == null) {
                                        if (entry == null || this.update && FileMode.GITLINK != entry.getFileMode()) continue;
                                        builder.add(entry);
                                        continue;
                                    }
                                    if (entry != null && entry.isAssumeValid()) {
                                        builder.add(entry);
                                        continue;
                                    }
                                    if (f.getEntryRawMode() == 16384 && f.getIndexFileMode(c) != FileMode.GITLINK || f.getEntryRawMode() == 57344 && f.getIndexFileMode(c) == FileMode.TREE) {
                                        tw.enterSubtree();
                                        continue;
                                    }
                                    path = tw.getRawPath();
                                    if (entry == null || entry.getStage() > 0) {
                                        entry = new DirCacheEntry(path);
                                    }
                                    FileMode mode = f.getIndexFileMode(c);
                                    entry.setFileMode(mode);
                                    if (FileMode.GITLINK != mode) {
                                        entry.setLength(f.getEntryLength());
                                        entry.setLastModified(f.getEntryLastModifiedInstant());
                                        long len = f.getEntryContentLength();
                                        Throwable throwable2 = null;
                                        Object var18_23 = null;
                                        try (InputStream in = f.openEntryStream();){
                                            ObjectId id = inserter.insert(3, len, in);
                                            entry.setObjectId(id);
                                            break block47;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                            } else if (throwable2 != throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                    entry.setLength(0);
                                    entry.setLastModified(Instant.ofEpochSecond(0L));
                                    entry.setObjectId(f.getEntryObjectId());
                                }
                                builder.add(entry);
                                lastAdded = path;
                            }
                            inserter.flush();
                            builder.commit();
                            this.setCallable(false);
                        }
                        if (inserter != null) {
                            inserter.close();
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (inserter != null) {
                            inserter.close();
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof FilterFailedException) {
                    throw (FilterFailedException)cause;
                }
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, e);
            }
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }

    public AddCommand setUpdate(boolean update) {
        this.update = update;
        return this;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public AddCommand setRenormalize(boolean renormalize) {
        this.renormalize = renormalize;
        return this;
    }

    public boolean isRenormalize() {
        return this.renormalize;
    }
}

