/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.retention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyType;

public enum RetentionPolicyCodec {
    INSTANCE;


    public RetentionPolicy decodePolicy(List<RetentionPolicyType> availablePolicyTypes, String encodedPolicyOriginal) {
        String encodedTypeName;
        Map<String, String> config;
        Objects.requireNonNull(availablePolicyTypes);
        Objects.requireNonNull(encodedPolicyOriginal);
        String encodedPolicy = encodedPolicyOriginal.trim();
        int firstSpace = encodedPolicy.indexOf(32);
        if (firstSpace == -1) {
            config = null;
            encodedTypeName = encodedPolicy.trim();
        } else {
            encodedTypeName = encodedPolicy.substring(0, firstSpace).trim();
            config = RetentionPolicyCodec.decodeMap(encodedPolicy.substring(firstSpace + 1));
        }
        for (RetentionPolicyType rtp : availablePolicyTypes) {
            if (!rtp.getEncodedName().equals(encodedTypeName)) continue;
            return rtp.createPolicy(config);
        }
        SystemLogger.syslog().debug("Ignoring invalid retention policy " + encodedPolicy);
        return null;
    }

    public String encodePolicy(RetentionPolicyType policyType, Map<String, String> config) {
        return policyType.getEncodedName() + " " + RetentionPolicyCodec.encodeMap(config);
    }

    static String encodeMap(Map<String, String> map) {
        StringBuilder out = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        boolean isFirst = true;
        for (String key : keys) {
            if (!RetentionPolicyCodec.isValidForEncode(key)) {
                SystemLogger.syslog().debug("Ignoring invalid key " + key);
                continue;
            }
            String value = map.get(key);
            if (!RetentionPolicyCodec.isValidForEncode(value)) {
                SystemLogger.syslog().debug("Ignoring invalid value " + value);
                continue;
            }
            if (!isFirst) {
                out.append(' ');
            } else {
                isFirst = false;
            }
            out.append(key);
            out.append('=');
            out.append(value);
        }
        return out.toString();
    }

    static Map<String, String> decodeMap(String encodedMap) {
        String[] tokens;
        HashMap<String, String> out = new HashMap<String, String>();
        for (String token : tokens = encodedMap.split(" ")) {
            Object[] keyVal = token.split("=");
            if (keyVal.length != 2) {
                SystemLogger.syslog().debug("Ignoring invalid token " + Arrays.toString(keyVal));
                continue;
            }
            out.put(((String)keyVal[0]).trim(), ((String)keyVal[1]).trim());
        }
        return out;
    }

    private static boolean isValidForEncode(String keyOrVal) {
        return !keyOrVal.contains("=") && !keyOrVal.contains(" ");
    }
}

