/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.repo;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.repo.JGitSupplier;
import net.pcal.fastback.repo.RepoImpl;
import net.pcal.fastback.repo.SnapshotId;
import net.pcal.fastback.repo.SnapshotIdUtils;
import net.pcal.fastback.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import net.pcal.fastback.shaded.org.eclipse.jgit.lib.Ref;

abstract class BranchUtils {
    BranchUtils() {
    }

    static Set<SnapshotId> listSnapshots(RepoImpl repo, JGitSupplier<Collection<Ref>> refProvider) throws GitAPIException, IOException {
        Collection<Ref> refs = refProvider.get();
        SnapshotIdUtils.SnapshotIdCodec codec = repo.getSidCodec();
        HashSet<SnapshotId> out = new HashSet<SnapshotId>();
        for (Ref ref : refs) {
            String branchName = BranchUtils.getBranchName(ref);
            if (repo.getSidCodec().isSnapshotBranchName(repo.getWorldId(), branchName)) {
                SnapshotId sid;
                try {
                    sid = Objects.requireNonNull(codec.fromBranch(branchName));
                }
                catch (ParseException pe) {
                    SystemLogger.syslog().error("Unexpected parse error, ignoring branch " + branchName, pe);
                    continue;
                }
                if (sid.getWorldId().equals(repo.getWorldId())) {
                    out.add(sid);
                    continue;
                }
                SystemLogger.syslog().debug("Ignoring branch from other world " + branchName);
                continue;
            }
            SystemLogger.syslog().debug("Ignoring unrecognized branch " + branchName);
        }
        return out;
    }

    static String getBranchName(Ref fromBranchRef) {
        String REFS_HEADS = "refs/heads/";
        String name = fromBranchRef.getName();
        if (name.startsWith("refs/heads/")) {
            return name.substring("refs/heads/".length());
        }
        return null;
    }
}

