/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.mod.forge;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.MinecraftProvider;
import net.pcal.fastback.mod.forge.ForgeCommonProvider;

final class ForgeClientProvider
extends ForgeCommonProvider {
    private static final long TEXT_TIMEOUT = 10000L;
    private Component hudText;
    private long hudTextTime;
    private final Minecraft client;

    public ForgeClientProvider() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onClientStartupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onGuiOverlayEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onScreenRenderEvent);
        this.client = Objects.requireNonNull(Minecraft.m_91087_(), "MinecraftClient.getInstance() returned null");
    }

    private void onClientStartupEvent(FMLClientSetupEvent event) {
        this.onInitialize();
    }

    private void onGuiOverlayEvent(RenderGuiOverlayEvent.Post event) {
        this.renderOverlayText(event.getGuiGraphics());
    }

    private void onScreenRenderEvent(ScreenEvent.Render.Post event) {
        this.renderOverlayText(event.getGuiGraphics());
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void setHudText(UserMessage userMessage) {
        if (userMessage == null) {
            this.clearHudText();
        } else {
            this.hudText = MinecraftProvider.messageToText(userMessage);
            this.hudTextTime = System.currentTimeMillis();
        }
    }

    @Override
    public void clearHudText() {
        this.hudText = null;
    }

    @Override
    public void setMessageScreenText(UserMessage userMessage) {
        Component text;
        this.hudText = text = MinecraftProvider.messageToText(userMessage);
        Screen screen = this.client.f_91080_;
        if (screen != null) {
            screen.f_96539_ = text;
        }
    }

    @Override
    void renderOverlayText(GuiGraphics drawContext) {
        if (this.hudText == null) {
            return;
        }
        if (System.currentTimeMillis() - this.hudTextTime > 10000L) {
            this.hudText = null;
            SystemLogger.syslog().debug("hud text timed out.  somebody forgot to clean up");
            return;
        }
        if (this.client != null) {
            drawContext.m_280430_(this.client.f_91062_, this.hudText, 2, 2, 1);
        }
    }
}

