/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.logging;

import java.util.Objects;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.utils.ProcessException;
import org.apache.logging.log4j.Logger;

public class Log4jLogger
implements SystemLogger {
    private final Logger log4j;
    private boolean forceDebugEnabled = false;

    public Log4jLogger(Logger log4j) {
        this.log4j = Objects.requireNonNull(log4j);
    }

    @Override
    public void setForceDebugEnabled(boolean forceDebugEnabled) {
        this.forceDebugEnabled = forceDebugEnabled;
    }

    @Override
    public void error(String message) {
        this.log4j.error(message);
    }

    @Override
    public void error(String message, Throwable t) {
        if (t instanceof ProcessException) {
            ProcessException pe = (ProcessException)t;
            pe.writeProcessOutput(this::error);
        }
        this.log4j.error(message, t);
    }

    @Override
    public void warn(String message) {
        this.log4j.warn(message);
    }

    @Override
    public void info(String message) {
        this.log4j.info(message);
    }

    @Override
    public void debug(String message) {
        if (this.forceDebugEnabled) {
            this.log4j.info("[DEBUG] " + message);
        } else {
            this.log4j.debug(message);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (this.forceDebugEnabled) {
            if (t instanceof ProcessException) {
                ProcessException pe = (ProcessException)t;
                pe.writeProcessOutput(line -> this.log4j.info("[DEBUG] " + message));
            }
            this.log4j.info("[DEBUG] " + message, t);
        } else {
            this.log4j.debug(message, t);
        }
    }
}

