/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.commands.SnapshotNameSuggestions;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.utils.Executor;

enum RemoteRestoreCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "remote-restore";
    private static final String ARGUMENT = "snapshot";

    @Override
    public void register(LiteralArgumentBuilder<CommandSourceStack> argb, PermissionsFactory<CommandSourceStack> pf) {
        argb.then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).then(net.minecraft.commands.Commands.m_82129_((String)ARGUMENT, (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)SnapshotNameSuggestions.remote()).executes(RemoteRestoreCommand::remoteRestore)));
    }

    private static int remoteRestore(CommandContext<CommandSourceStack> cc) {
        UserLogger ulog = UserLogger.ulog(cc);
        Commands.gitOp(Executor.ExecutionLock.NONE, ulog, repo -> {
            String snapshotName = (String)cc.getLastChild().getArgument(ARGUMENT, String.class);
            repo.doRestoreRemoteSnapshot(snapshotName, ulog);
        });
        return 1;
    }
}

