/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.commands.CommandSourceStack;
import net.pcal.fastback.commands.Command;
import net.pcal.fastback.commands.Commands;
import net.pcal.fastback.commands.PermissionsFactory;
import net.pcal.fastback.logging.SystemLogger;
import net.pcal.fastback.logging.UserLogger;
import net.pcal.fastback.logging.UserMessage;
import net.pcal.fastback.mod.Mod;
import net.pcal.fastback.repo.RepoFactory;

enum HelpCommand implements Command
{
    INSTANCE;

    private static final String COMMAND_NAME = "help";
    private static final String ARGUMENT = "subcommand";

    @Override
    public void register(LiteralArgumentBuilder<CommandSourceStack> argb, PermissionsFactory<CommandSourceStack> pf) {
        argb.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)COMMAND_NAME).requires(Commands.subcommandPermission(COMMAND_NAME, pf))).executes(HelpCommand::generalHelp)).then(net.minecraft.commands.Commands.m_82129_((String)ARGUMENT, (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new HelpTopicSuggestions()).executes(this::subcommandHelp)));
    }

    static int generalHelp(CommandContext<CommandSourceStack> cc) {
        try (UserLogger ulog = UserLogger.ulog(cc);){
            StringWriter subcommands = null;
            for (String available : HelpCommand.getSubcommandNames(cc)) {
                if (subcommands == null) {
                    subcommands = new StringWriter();
                } else {
                    subcommands.append(", ");
                }
                subcommands.append(available);
            }
            ulog.message(UserMessage.localized("fastback.help.subcommands", String.valueOf(subcommands)));
            if (!RepoFactory.rf().isGitRepo(Mod.mod().getWorldDirectory())) {
                ulog.message(UserMessage.localized("fastback.help.suggest-init", new Object[0]));
            }
            int n = 1;
            return n;
        }
    }

    private int subcommandHelp(CommandContext<CommandSourceStack> cc) {
        try (UserLogger ulog = UserLogger.ulog(cc);){
            String subcommand = (String)cc.getLastChild().getArgument(ARGUMENT, String.class);
            for (String available : HelpCommand.getSubcommandNames(cc)) {
                if (!subcommand.equals(available)) continue;
                String prefix = "/backup " + subcommand + ": ";
                ulog.message(UserMessage.localized("fastback.help.command." + subcommand, prefix));
                int n = 1;
                return n;
            }
            ulog.message(UserMessage.styledLocalized("fastback.chat.invalid-input", UserMessage.UserMessageStyle.ERROR, subcommand));
        }
        return 0;
    }

    private static List<String> getSubcommandNames(CommandContext<CommandSourceStack> cc) {
        ArrayList<String> out = new ArrayList<String>();
        ((ParsedCommandNode)cc.getNodes().get(0)).getNode().getChildren().forEach(node -> out.add(node.getName()));
        return out;
    }

    private static class HelpTopicSuggestions
    implements SuggestionProvider<CommandSourceStack> {
        HelpTopicSuggestions() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> cc, SuggestionsBuilder builder) {
            CompletableFuture<Suggestions> completableFuture = new CompletableFuture<Suggestions>();
            HelpCommand.getSubcommandNames(cc).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            try {
                completableFuture.complete((Suggestions)builder.buildFuture().get());
            }
            catch (InterruptedException | ExecutionException e) {
                SystemLogger.syslog().error("looking up help topics", e);
                return null;
            }
            return completableFuture;
        }
    }
}

