/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.client.renderer.tileentity;

import li.cil.oc.Settings$;
import li.cil.oc.api.Items;
import li.cil.oc.api.detail.ItemInfo;
import li.cil.oc.client.Textures$;
import li.cil.oc.common.tileentity.Screen;
import li.cil.oc.integration.util.Wrench$;
import li.cil.oc.util.RenderState$;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GLContext;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class ScreenRenderer$
extends TileEntitySpecialRenderer {
    public static final ScreenRenderer$ MODULE$;
    private final double maxRenderDistanceSq;
    private final double fadeDistanceSq;
    private final double fadeRatio;
    private Screen screen;
    private Set<ItemInfo> screens;
    private final boolean canUseBlendColor;
    private volatile boolean bitmap$0;

    static {
        new ScreenRenderer$();
    }

    private Set screens$lzycompute() {
        ScreenRenderer$ screenRenderer$ = this;
        synchronized (screenRenderer$) {
            if (!this.bitmap$0) {
                this.screens = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ItemInfo[]{Items.get("screen1"), Items.get("screen2"), Items.get("screen3")}));
                this.bitmap$0 = true;
            }
            return this.screens;
        }
    }

    private double maxRenderDistanceSq() {
        return this.maxRenderDistanceSq;
    }

    private double fadeDistanceSq() {
        return this.fadeDistanceSq;
    }

    private double fadeRatio() {
        return this.fadeRatio;
    }

    private Screen screen() {
        return this.screen;
    }

    private void screen_$eq(Screen x$1) {
        this.screen = x$1;
    }

    private Set<ItemInfo> screens() {
        return this.bitmap$0 ? this.screens : this.screens$lzycompute();
    }

    private boolean canUseBlendColor() {
        return this.canUseBlendColor;
    }

    public void func_147500_a(TileEntity t, double x, double y, double z, float f) {
        RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".renderTileEntityAt: entering (aka: wasntme)").toString());
        this.screen_$eq((Screen)t);
        if (this.screen().isOrigin()) {
            double distance = this.playerDistanceSq() / (double)package$.MODULE$.min(this.screen().width(), this.screen().height());
            if (distance > this.maxRenderDistanceSq()) {
                return;
            }
            ForgeDirection screenFacing = this.screen().facing().getOpposite();
            if ((double)screenFacing.offsetX * (x + 0.5) + (double)screenFacing.offsetY * (y + 0.5) + (double)screenFacing.offsetZ * (z + 0.5) < 0.0) {
                return;
            }
            RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".renderTileEntityAt: checks").toString());
            GL11.glPushAttrib((int)1048575);
            RenderState$.MODULE$.disableLighting();
            RenderState$.MODULE$.makeItBlend();
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".renderTileEntityAt: setup").toString());
            this.drawOverlay();
            RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".renderTileEntityAt: overlay").toString());
            if (distance > this.fadeDistanceSq()) {
                float alpha = package$.MODULE$.max(0.0f, 1.0f - (float)((distance - this.fadeDistanceSq()) * this.fadeRatio()));
                if (this.canUseBlendColor()) {
                    GL14.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
                    GL11.glBlendFunc((int)32771, (int)1);
                }
            }
            RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".renderTileEntityAt: fade").toString());
            if (this.screen().buffer().isRenderingEnabled()) {
                this.draw();
            }
            RenderState$.MODULE$.enableLighting();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
            RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".renderTileEntityAt: leaving").toString());
            return;
        }
    }

    private void transform() {
        ForgeDirection forgeDirection = this.screen().yaw();
        if (ForgeDirection.WEST.equals(forgeDirection)) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.NORTH.equals(forgeDirection)) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.EAST.equals(forgeDirection)) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ForgeDirection forgeDirection2 = this.screen().pitch();
        if (ForgeDirection.DOWN.equals(forgeDirection2)) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ForgeDirection.UP.equals(forgeDirection2)) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.5f);
        GL11.glTranslatef((float)0.0f, (float)this.screen().height(), (float)0.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
    }

    private void drawOverlay() {
        block5: {
            ItemStack stack;
            block4: {
                ForgeDirection forgeDirection = this.screen().facing();
                ForgeDirection forgeDirection2 = ForgeDirection.UP;
                if (!(forgeDirection == null ? forgeDirection2 != null : !forgeDirection.equals(forgeDirection2))) break block4;
                ForgeDirection forgeDirection3 = this.screen().facing();
                ForgeDirection forgeDirection4 = ForgeDirection.DOWN;
                if (forgeDirection3 != null ? !forgeDirection3.equals(forgeDirection4) : forgeDirection4 != null) break block5;
            }
            if ((stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm()) != null && (Wrench$.MODULE$.holdsApplicableWrench((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.screen().position()) || this.screens().contains((Object)Items.get(stack)))) {
                GL11.glPushMatrix();
                this.transform();
                this.func_147499_a(Textures$.MODULE$.blockScreenUpIndicator());
                GL11.glDepthMask((boolean)false);
                GL11.glTranslatef((float)((float)this.screen().width() / 2.0f - 0.5f), (float)((float)this.screen().height() / 2.0f - 0.5f), (float)0.05f);
                Tessellator t = Tessellator.field_78398_a;
                t.func_78382_b();
                t.func_78374_a(0.0, 1.0, 0.0, 0.0, 1.0);
                t.func_78374_a(1.0, 1.0, 0.0, 1.0, 1.0);
                t.func_78374_a(1.0, 0.0, 0.0, 1.0, 0.0);
                t.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
                t.func_78381_a();
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            }
        }
    }

    private void draw() {
        RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".draw: entering (aka: wasntme)").toString());
        int sx = this.screen().width();
        int sy = this.screen().height();
        float tw = (float)sx * 16.0f;
        float th = (float)sy * 16.0f;
        this.transform();
        GL11.glTranslatef((float)((float)sx * 2.25f / tw), (float)((float)sy * 2.25f / th), (float)0.0f);
        float isx = (float)sx - 0.28125f;
        float isy = (float)sy - 0.28125f;
        int sizeX = this.screen().buffer().renderWidth();
        int sizeY = this.screen().buffer().renderHeight();
        float scaleX = isx / (float)sizeX;
        float scaleY = isy / (float)sizeY;
        if (scaleX > scaleY) {
            GL11.glTranslatef((float)((float)sizeX * 0.5f * (scaleX - scaleY)), (float)0.0f, (float)0.0f);
            GL11.glScalef((float)scaleY, (float)scaleY, (float)1.0f);
        } else {
            GL11.glTranslatef((float)0.0f, (float)((float)sizeY * 0.5f * (scaleY - scaleX)), (float)0.0f);
            GL11.glScalef((float)scaleX, (float)scaleX, (float)1.0f);
        }
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.01);
        RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".draw: setup").toString());
        this.screen().buffer().renderText();
        RenderState$.MODULE$.checkError(new StringBuilder().append((Object)((Object)((Object)this)).getClass().getName()).append((Object)".draw: text").toString());
    }

    private double playerDistanceSq() {
        double d;
        double d2;
        double d3;
        EntityClientPlayerMP player2 = Minecraft.func_71410_x().field_71439_g;
        AxisAlignedBB bounds = this.screen().getRenderBoundingBox();
        double px = player2.field_70165_t;
        double py = player2.field_70163_u;
        double pz = player2.field_70161_v;
        double ex = bounds.field_72336_d - bounds.field_72340_a;
        double ey = bounds.field_72337_e - bounds.field_72338_b;
        double ez = bounds.field_72334_f - bounds.field_72339_c;
        double cx = bounds.field_72340_a + ex * 0.5;
        double cy = bounds.field_72338_b + ey * 0.5;
        double cz = bounds.field_72339_c + ez * 0.5;
        double dx = px - cx;
        double dy = py - cy;
        double dz = pz - cz;
        if (dx < -ex) {
            double d4 = dx + ex;
            d3 = d4 * d4;
        } else if (dx > ex) {
            double d5 = dx - ex;
            d3 = d5 * d5;
        } else {
            d3 = 0.0;
        }
        if (dy < -ey) {
            double d6 = dy + ey;
            d2 = d6 * d6;
        } else if (dy > ey) {
            double d7 = dy - ey;
            d2 = d7 * d7;
        } else {
            d2 = 0.0;
        }
        double d8 = d3 + d2;
        if (dz < -ez) {
            double d9 = dz + ez;
            d = d9 * d9;
        } else if (dz > ez) {
            double d10 = dz - ez;
            d = d10 * d10;
        } else {
            d = 0.0;
        }
        return d8 + d;
    }

    private ScreenRenderer$() {
        MODULE$ = this;
        this.maxRenderDistanceSq = Settings$.MODULE$.get().maxScreenTextRenderDistance() * Settings$.MODULE$.get().maxScreenTextRenderDistance();
        this.fadeDistanceSq = Settings$.MODULE$.get().screenTextFadeStartDistance() * Settings$.MODULE$.get().screenTextFadeStartDistance();
        this.fadeRatio = 1.0 / (this.maxRenderDistanceSq() - this.fadeDistanceSq());
        this.screen = null;
        this.canUseBlendColor = GLContext.getCapabilities().OpenGL14;
    }
}

