/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.api;

import codechicken.core.featurehack.GameDataManipulator;
import codechicken.nei.InfiniteStackSizeHandler;
import codechicken.nei.InfiniteToolHandler;
import codechicken.nei.ItemList;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.ItemStackMap;
import codechicken.nei.ItemStackSet;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PopupInputHandler;
import codechicken.nei.api.API;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.config.ArrayDumper;
import codechicken.nei.config.ItemPanelDumper;
import codechicken.nei.config.RegistryDumper;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.BrewingRecipeHandler;
import codechicken.nei.recipe.RecipeItemInputHandler;
import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IShearable;

public class ItemInfo {
    public static final ArrayListMultimap<Layout, IHighlightHandler> highlightHandlers = ArrayListMultimap.create();
    public static final ItemStackMap<String> nameOverrides = new ItemStackMap();
    public static final ItemStackSet hiddenItems = new ItemStackSet();
    public static final ItemStackSet finiteItems = new ItemStackSet();
    public static final ArrayListMultimap<Item, ItemStack> itemOverrides = ArrayListMultimap.create();
    public static final ArrayListMultimap<Item, ItemStack> itemVariants = ArrayListMultimap.create();
    public static final LinkedList<IInfiniteItemHandler> infiniteHandlers = new LinkedList();
    public static final ArrayListMultimap<Block, IHighlightHandler> highlightIdentifiers = ArrayListMultimap.create();
    public static final HashSet<Class<? extends Slot>> fastTransferExemptions = new HashSet();
    public static final HashMap<Item, String> itemOwners = new HashMap();
    public static final HashMap<ItemStack, String> itemSearchNames = new HashMap();

    public static boolean isHidden(ItemStack stack) {
        return hiddenItems.contains(stack);
    }

    public static boolean isHidden(Item item) {
        return hiddenItems.containsAll(item);
    }

    public static String getNameOverride(ItemStack stack) {
        return nameOverrides.get(stack);
    }

    public static boolean canBeInfinite(ItemStack stack) {
        return !finiteItems.contains(stack);
    }

    @Deprecated
    public static List<ItemStack> getItemOverrides(Item item) {
        return itemOverrides.get((Object)item);
    }

    public static void preInit() {
        ItemInfo.addMobSpawnerItem();
    }

    public static void load(World world) {
        ItemInfo.addVanillaBlockProperties();
        ItemInfo.addDefaultDropDowns();
        ItemInfo.searchItems();
        ItemInfo.parseModItems();
        ItemMobSpawner.loadSpawners(world);
        ItemInfo.addSpawnEggs();
        ItemInfo.addInfiniteHandlers();
        ItemInfo.addInputHandlers();
        ItemInfo.addIDDumps();
        ItemInfo.addHiddenItemFilter();
        ItemInfo.addSearchOptimisation();
    }

    private static void addSearchOptimisation() {
        ItemList.loadCallbacks.add(new ItemList.ItemsLoadedCallback(){

            @Override
            public void itemsLoaded() {
                itemSearchNames.clear();
            }
        });
    }

    private static void addHiddenItemFilter() {
        API.addItemFilter(new ItemFilter.ItemFilterProvider(){

            @Override
            public ItemFilter getFilter() {
                return new ItemFilter(){

                    @Override
                    public boolean matches(ItemStack item) {
                        return !hiddenItems.contains(item);
                    }
                };
            }
        });
    }

    private static void addIDDumps() {
        API.addOption(new RegistryDumper<Item>("tools.dump.item"){

            @Override
            public String[] header() {
                return new String[]{"Name", "ID", "Has Block", "Mod", "Class"};
            }

            @Override
            public String[] dump(Item item, int id, String name) {
                return new String[]{name, Integer.toString(id), Boolean.toString(Block.func_149634_a((Item)item) != Blocks.field_150350_a), itemOwners.get(item), item.getClass().getCanonicalName()};
            }

            @Override
            public RegistryNamespaced registry() {
                return Item.field_150901_e;
            }
        });
        API.addOption(new RegistryDumper<Block>("tools.dump.block"){

            @Override
            public String[] header() {
                return new String[]{"Name", "ID", "Has Item", "Mod", "Class"};
            }

            @Override
            public String[] dump(Block item, int id, String name) {
                return new String[]{name, Integer.toString(id), Boolean.toString(Item.func_150898_a((Block)item) != null), itemOwners.get(item), item.getClass().getCanonicalName()};
            }

            @Override
            public RegistryNamespaced registry() {
                return Block.field_149771_c;
            }
        });
        API.addOption(new ArrayDumper<Potion>("tools.dump.potion"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Unlocalised name", "Class"};
            }

            @Override
            public String[] dump(Potion potion, int id) {
                return new String[]{Integer.toString(id), potion.func_76393_a(), potion.getClass().getCanonicalName()};
            }

            public Potion[] array() {
                return Potion.field_76425_a;
            }
        });
        API.addOption(new ArrayDumper<Enchantment>("tools.dump.enchantment"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Unlocalised name", "Type", "Min Level", "Max Level", "Class"};
            }

            @Override
            public String[] dump(Enchantment ench, int id) {
                return new String[]{Integer.toString(id), ench.func_77320_a(), ench.field_77351_y.toString(), Integer.toString(ench.func_77319_d()), Integer.toString(ench.func_77325_b()), ench.getClass().getCanonicalName()};
            }

            public Enchantment[] array() {
                return Enchantment.field_77331_b;
            }
        });
        API.addOption(new ArrayDumper<BiomeGenBase>("tools.dump.biome"){

            @Override
            public String[] header() {
                return new String[]{"ID", "Name", "Temperature", "Rainfall", "Spawn Chance", "Root Height", "Height Variation", "Types", "Class"};
            }

            @Override
            public String[] dump(BiomeGenBase biome, int id) {
                BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                StringBuilder s_types = new StringBuilder();
                for (BiomeDictionary.Type t : types) {
                    if (s_types.length() > 0) {
                        s_types.append(", ");
                    }
                    s_types.append(t.name());
                }
                return new String[]{Integer.toString(id), biome.field_76791_y, Float.toString(biome.func_150564_a(0, 0, 0)), Float.toString(biome.func_76727_i()), Float.toString(biome.func_76741_f()), Float.toString(biome.field_76748_D), Float.toString(biome.field_76749_E), s_types.toString(), biome.getClass().getCanonicalName()};
            }

            public BiomeGenBase[] array() {
                return BiomeGenBase.func_150565_n();
            }
        });
        API.addOption(new ItemPanelDumper("tools.dump.itempanel"));
    }

    private static void parseModItems() {
        HashMap<String, ItemStackSet> modSubsets = new HashMap<String, ItemStackSet>();
        for (Item item : Item.field_150901_e) {
            GameRegistry.UniqueIdentifier ident = null;
            try {
                ident = GameRegistry.findUniqueIdentifierFor((Item)item);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (ident == null) {
                NEIClientConfig.logger.error("Failed to find identifier for: " + item);
                continue;
            }
            String modId = ident.modId;
            itemOwners.put(item, modId);
            ItemStackSet itemset = (ItemStackSet)modSubsets.get(modId);
            if (itemset == null) {
                itemset = new ItemStackSet();
                modSubsets.put(modId, itemset);
            }
            itemset.with(item);
        }
        API.addSubset("Mod.Minecraft", (ItemFilter)modSubsets.remove("minecraft"));
        for (Map.Entry entry : modSubsets.entrySet()) {
            ModContainer mc = FMLCommonHandler.instance().findContainerFor(entry.getKey());
            if (mc == null) {
                NEIClientConfig.logger.error("Missing container for " + (String)entry.getKey());
                continue;
            }
            API.addSubset("Mod." + mc.getName(), (ItemFilter)entry.getValue());
        }
    }

    private static void addInputHandlers() {
        GuiContainerManager.addInputHandler(new RecipeItemInputHandler());
        GuiContainerManager.addInputHandler(new PopupInputHandler());
    }

    private static void addMobSpawnerItem() {
        GameDataManipulator.replaceItem((int)Block.func_149682_b((Block)Blocks.field_150474_ac), (Item)new ItemMobSpawner());
    }

    private static void addInfiniteHandlers() {
        API.addInfiniteItemHandler(new InfiniteStackSizeHandler());
        API.addInfiniteItemHandler(new InfiniteToolHandler());
    }

    private static void addVanillaBlockProperties() {
        API.setOverrideName(new ItemStack((Block)Blocks.field_150358_i), "Water Source");
        API.setOverrideName(new ItemStack(Blocks.field_150355_j), "Water Still");
        API.setOverrideName(new ItemStack((Block)Blocks.field_150356_k), "Lava Source");
        API.setOverrideName(new ItemStack(Blocks.field_150353_l), "Lava Still");
        API.setOverrideName(new ItemStack(Blocks.field_150384_bq), "End Portal");
        API.setOverrideName(new ItemStack(Blocks.field_150378_br), "End Portal Frame");
        API.hideItem(new ItemStack((Block)Blocks.field_150334_T, 1, Short.MAX_VALUE));
        API.hideItem(new ItemStack((Block)Blocks.field_150373_bw, 1, Short.MAX_VALUE));
        API.hideItem(new ItemStack(Blocks.field_150459_bM));
        API.hideItem(new ItemStack(Blocks.field_150469_bN));
        API.hideItem(new ItemStack(Blocks.field_150375_by));
    }

    private static void addDefaultDropDowns() {
        API.addSubset("Items", new ItemFilter(){

            @Override
            public boolean matches(ItemStack item) {
                return Block.func_149634_a((Item)item.func_77973_b()) == Blocks.field_150350_a;
            }
        });
        API.addSubset("Blocks", new ItemFilter(){

            @Override
            public boolean matches(ItemStack item) {
                return Block.func_149634_a((Item)item.func_77973_b()) != Blocks.field_150350_a;
            }
        });
        API.addSubset("Blocks.MobSpawners", ItemStackSet.of(Blocks.field_150474_ac));
    }

    private static void searchItems() {
        ItemStackSet tools = new ItemStackSet();
        ItemStackSet picks = new ItemStackSet();
        ItemStackSet shovels = new ItemStackSet();
        ItemStackSet axes = new ItemStackSet();
        ItemStackSet hoes = new ItemStackSet();
        ItemStackSet swords = new ItemStackSet();
        ItemStackSet chest = new ItemStackSet();
        ItemStackSet helmets = new ItemStackSet();
        ItemStackSet legs = new ItemStackSet();
        ItemStackSet boots = new ItemStackSet();
        ItemStackSet other = new ItemStackSet();
        ItemStackSet ranged = new ItemStackSet();
        ItemStackSet food = new ItemStackSet();
        ItemStackSet potioningredients = new ItemStackSet();
        ArrayList<ItemStackSet> creativeTabRanges = new ArrayList<ItemStackSet>(CreativeTabs.field_78032_a.length);
        LinkedList stackList = new LinkedList();
        for (Item item : Item.field_150901_e) {
            if (item == null) continue;
            for (CreativeTabs itemTab : item.getCreativeTabs()) {
                if (itemTab == null) continue;
                while (itemTab.func_78021_a() >= creativeTabRanges.size()) {
                    creativeTabRanges.add(null);
                }
                ItemStackSet set = (ItemStackSet)creativeTabRanges.get(itemTab.func_78021_a());
                if (set == null) {
                    set = new ItemStackSet();
                    creativeTabRanges.set(itemTab.func_78021_a(), set);
                }
                try {
                    stackList.clear();
                    item.func_150895_a(item, itemTab, stackList);
                    for (ItemStack stack : stackList) {
                        set.add(stack);
                    }
                }
                catch (Exception e) {
                    NEIClientConfig.logger.error("Error loading sub-items for: " + item + ". Tab: " + itemTab.func_78013_b(), (Throwable)e);
                }
            }
            if (item.func_77645_m()) {
                tools.with(item);
                if (item instanceof ItemPickaxe) {
                    picks.with(item);
                } else if (item instanceof ItemSpade) {
                    shovels.with(item);
                } else if (item instanceof ItemAxe) {
                    axes.with(item);
                } else if (item instanceof ItemHoe) {
                    hoes.with(item);
                } else if (item instanceof ItemSword) {
                    swords.with(item);
                } else if (item instanceof ItemArmor) {
                    switch (((ItemArmor)item).field_77881_a) {
                        case 0: {
                            helmets.with(item);
                            break;
                        }
                        case 1: {
                            chest.with(item);
                            break;
                        }
                        case 2: {
                            legs.with(item);
                            break;
                        }
                        case 3: {
                            boots.with(item);
                        }
                    }
                } else if (item == Items.field_151032_g || item == Items.field_151031_f) {
                    ranged.with(item);
                } else if (item == Items.field_151112_aM || item == Items.field_151033_d || item == Items.field_151097_aZ) {
                    other.with(item);
                }
            }
            if (item instanceof ItemFood) {
                food.with(item);
            }
            try {
                LinkedList subItems = new LinkedList();
                item.func_150895_a(item, null, subItems);
                for (ItemStack stack : subItems) {
                    if (!item.func_150892_m(stack) || item.func_150896_i(stack) == null) continue;
                    BrewingRecipeHandler.ingredients.add(stack);
                    potioningredients.add(stack);
                }
            }
            catch (Exception e) {
                NEIClientConfig.logger.error("Error loading brewing ingredients for: " + item, (Throwable)e);
            }
        }
        API.addSubset("Items.Tools.Pickaxes", picks);
        API.addSubset("Items.Tools.Shovels", shovels);
        API.addSubset("Items.Tools.Axes", axes);
        API.addSubset("Items.Tools.Hoes", hoes);
        API.addSubset("Items.Tools.Other", other);
        API.addSubset("Items.Weapons.Swords", swords);
        API.addSubset("Items.Weapons.Ranged", ranged);
        API.addSubset("Items.Armor.Chestplates", chest);
        API.addSubset("Items.Armor.Leggings", legs);
        API.addSubset("Items.Armor.Helmets", helmets);
        API.addSubset("Items.Armor.Boots", boots);
        API.addSubset("Items.Food", food);
        API.addSubset("Items.Potions.Ingredients", potioningredients);
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            ItemStackSet set;
            if (tab.func_78021_a() >= creativeTabRanges.size() || (set = (ItemStackSet)creativeTabRanges.get(tab.func_78021_a())) == null || set.isEmpty()) continue;
            API.addSubset("CreativeTabs." + I18n.func_135052_a((String)tab.func_78024_c(), (Object[])new Object[0]), set);
        }
        BrewingRecipeHandler.searchPotions();
    }

    private static void addSpawnEggs() {
        ItemInfo.addEntityEgg(EntitySnowman.class, 0xEEFFFF, 16753185);
        ItemInfo.addEntityEgg(EntityIronGolem.class, 12960449, 16769484);
    }

    private static void addEntityEgg(Class<?> entity, int i, int j) {
        int id = (Integer)EntityList.field_75624_e.get(entity);
        EntityList.field_75627_a.put(id, new EntityList.EntityEggInfo(id, i, j));
    }

    public static ArrayList<ItemStack> getIdentifierItems(World world, EntityPlayer player, MovingObjectPosition hit) {
        IShearable shearable;
        int x = hit.field_72311_b;
        int y = hit.field_72312_c;
        int z = hit.field_72309_d;
        Block mouseoverBlock = world.func_147439_a(x, y, z);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList handlers = new ArrayList();
        if (highlightIdentifiers.containsKey(null)) {
            handlers.addAll(highlightIdentifiers.get(null));
        }
        if (highlightIdentifiers.containsKey((Object)mouseoverBlock)) {
            handlers.addAll(highlightIdentifiers.get((Object)mouseoverBlock));
        }
        for (IHighlightHandler ident : handlers) {
            ItemStack item = ident.identifyHighlight(world, player, hit);
            if (item == null) continue;
            items.add(item);
        }
        if (items.size() > 0) {
            return items;
        }
        ItemStack pick = mouseoverBlock.getPickBlock(hit, world, x, y, z, player);
        if (pick != null) {
            items.add(pick);
        }
        try {
            items.addAll(mouseoverBlock.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (mouseoverBlock instanceof IShearable && (shearable = (IShearable)mouseoverBlock).isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, x, y, z)) {
            items.addAll(shearable.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, x, y, z, 0));
        }
        if (items.size() == 0) {
            items.add(0, new ItemStack(mouseoverBlock, 1, world.func_72805_g(x, y, z)));
        }
        return items;
    }

    public static void registerHighlightHandler(IHighlightHandler handler, Layout ... layouts) {
        for (Layout layout : layouts) {
            highlightHandlers.get((Object)layout).add(handler);
        }
    }

    public static List<String> getText(ItemStack itemStack, World world, EntityPlayer player, MovingObjectPosition mop) {
        List<String> retString = new ArrayList<String>();
        for (Layout layout : Layout.values()) {
            for (IHighlightHandler handler : highlightHandlers.get((Object)layout)) {
                retString = handler.handleTextData(itemStack, world, player, mop, retString, layout);
            }
        }
        return retString;
    }

    public static String getSearchName(ItemStack stack) {
        String s = itemSearchNames.get(stack);
        if (s == null) {
            s = EnumChatFormatting.func_110646_a((String)GuiContainerManager.concatenatedDisplayName(stack, true).toLowerCase());
            itemSearchNames.put(stack, s);
        }
        return s;
    }

    public static enum Layout {
        HEADER,
        BODY,
        FOOTER;

    }
}

