/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render.uv;

import cofh.repack.codechicken.lib.render.uv.UV;
import cofh.repack.codechicken.lib.render.uv.UVTransformation;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class UVScale
extends UVTransformation {
    double su;
    double sv;

    public UVScale(double d, double d2) {
        this.su = d;
        this.sv = d2;
    }

    public UVScale(double d) {
        this(d, d);
    }

    @Override
    public void apply(UV uV) {
        uV.u *= this.su;
        uV.v *= this.sv;
    }

    @Override
    public UVTransformation inverse() {
        return new UVScale(1.0 / this.su, 1.0 / this.sv);
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "UVScale(" + new BigDecimal(this.su, mathContext) + ", " + new BigDecimal(this.sv, mathContext) + ")";
    }
}

