/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.world.gateways;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.world.PocketProvider;
import StevenDimDoors.mod_pocketDim.world.gateways.BaseGateway;
import StevenDimDoors.mod_pocketDim.world.gateways.GatewayLimbo;
import StevenDimDoors.mod_pocketDim.world.gateways.GatewaySandstonePillars;
import StevenDimDoors.mod_pocketDim.world.gateways.GatewayTwoPillars;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;

public class GatewayGenerator
implements IWorldGenerator {
    public static final int MAX_GATEWAY_GENERATION_CHANCE = 10000;
    public static final int MAX_CLUSTER_GENERATION_CHANCE = 10000;
    private static final int CLUSTER_GROWTH_CHANCE = 80;
    private static final int MAX_CLUSTER_GROWTH_CHANCE = 100;
    private static final int MIN_RIFT_Y = 4;
    private static final int MAX_RIFT_Y = 240;
    private static final int CHUNK_LENGTH = 16;
    private static final int GATEWAY_RADIUS = 4;
    private static final int MAX_GATEWAY_GENERATION_ATTEMPTS = 10;
    private static final int OVERWORLD_DIMENSION_ID = 0;
    private static final int NETHER_DIMENSION_ID = -1;
    private static final int END_DIMENSION_ID = 1;
    private static final String SPIRIT_WORLD_NAME = "Spirit World";
    private ArrayList<BaseGateway> gateways;
    private BaseGateway defaultGateway;
    private final DDProperties properties;

    public GatewayGenerator(DDProperties properties) {
        this.properties = properties;
        this.initialize();
    }

    private void initialize() {
        this.gateways = new ArrayList();
        this.defaultGateway = new GatewayTwoPillars(this.properties);
        this.gateways.add(new GatewaySandstonePillars(this.properties));
        this.gateways.add(new GatewayLimbo(this.properties));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int dimensionID = world.field_73011_w.field_76574_g;
        if (world.field_72995_K || world.field_73011_w instanceof PocketProvider || dimensionID == 1 || dimensionID == -1 || world.field_73011_w.func_80007_l().hashCode() == SPIRIT_WORLD_NAME.hashCode()) {
            return;
        }
        if (DimensionManager.getWorld((int)0) == null) {
            return;
        }
        if (mod_pocketDim.worldProperties.RiftClusterDimensions.isAccepted(dimensionID) && random.nextInt(10000) < this.properties.ClusterGenerationChance) {
            DimLink link = null;
            NewDimData dimension = null;
            do {
                int z;
                int x;
                int y;
                if ((y = world.func_72976_f(x = chunkX * 16 + random.nextInt(16), z = chunkZ * 16 + random.nextInt(16))) < 4 || y > 240 || !world.func_147437_c(x, y + 1, z) || world.func_147439_a(x, y, z) == Blocks.field_150357_h || world.func_147439_a(x, y - 1, z) == Blocks.field_150357_h || world.func_147439_a(x, y - 2, z) == Blocks.field_150357_h) continue;
                if (link == null) {
                    dimension = PocketManager.getDimensionData(world);
                    link = dimension.createLink(x, y + 1, z, LinkType.DUNGEON, 0);
                    continue;
                }
                dimension.createChildLink(x, y + 1, z, link);
            } while (random.nextInt(100) < 80);
        } else if (mod_pocketDim.worldProperties.RiftGatewayDimensions.isAccepted(dimensionID) && random.nextInt(10000) < this.properties.GatewayGenerationChance) {
            boolean valid = false;
            int z = 0;
            int y = 0;
            int x = 0;
            for (int attempts = 0; attempts < 10 && !valid; ++attempts) {
                x = chunkX * 16 + random.nextInt(16);
                z = chunkZ * 16 + random.nextInt(16);
                y = world.func_72976_f(x, z);
                valid = GatewayGenerator.checkGatewayLocation(world, x, y, z);
            }
            if (valid) {
                ArrayList<BaseGateway> validGateways = new ArrayList<BaseGateway>();
                for (BaseGateway gateway : this.gateways) {
                    if (!gateway.isLocationValid(world, x, y, z)) continue;
                    validGateways.add(gateway);
                }
                if (validGateways.isEmpty()) {
                    validGateways.add(this.defaultGateway);
                }
                ((BaseGateway)validGateways.get(random.nextInt(validGateways.size()))).generate(world, x, y - 1, z);
            }
        }
    }

    private static boolean checkGatewayLocation(World world, int x, int y, int z) {
        return y >= 4 && y <= 240 && world.func_147437_c(x, y + 1, z) && world.func_147439_a(x, y, z) != Blocks.field_150357_h && world.func_147439_a(x, y - 1, z) != Blocks.field_150357_h && GatewayGenerator.checkFoundationMaterial(world, x, y - 2, z);
    }

    private static boolean checkFoundationMaterial(World world, int x, int y, int z) {
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        return material != Material.field_151584_j && material != Material.field_151575_d && material != Material.field_151572_C && world.func_147445_c(x, y, z, false) && world.func_147439_a(x, y, z) != Blocks.field_150357_h;
    }
}

