/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.world.gateways;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.schematic.Schematic;
import StevenDimDoors.mod_pocketDim.schematic.SchematicFilter;
import net.minecraft.block.Block;

public class GatewayBlockFilter
extends SchematicFilter {
    private static final short STANDARD_WARP_DOOR_ID = 1975;
    private static final short STANDARD_DIMENSIONAL_DOOR_ID = 1970;
    private static final short STANDARD_TRANSIENT_DOOR_ID = 1979;
    private int entranceOrientation = 0;
    private Schematic schematic = null;
    private Point3D entranceDoorLocation = null;

    public GatewayBlockFilter() {
        super("GatewayEntranceFinder");
    }

    public int getEntranceOrientation() {
        return this.entranceOrientation;
    }

    public Point3D getEntranceDoorLocation() {
        return this.entranceDoorLocation;
    }

    @Override
    protected boolean initialize(Schematic schematic, Block[] blocks, byte[] metadata) {
        this.schematic = schematic;
        return true;
    }

    @Override
    protected boolean applyToBlock(int index, Block[] blocks, byte[] metadata) {
        int indexBelow;
        if (blocks[index] == mod_pocketDim.dimensionalDoor && (indexBelow = this.schematic.calculateIndexBelow(index)) >= 0 && blocks[indexBelow] == mod_pocketDim.dimensionalDoor) {
            this.entranceDoorLocation = this.schematic.calculatePoint(index);
            this.entranceOrientation = metadata[indexBelow] & 3;
            return true;
        }
        if (blocks[index] == mod_pocketDim.transientDoor && (indexBelow = this.schematic.calculateIndexBelow(index)) >= 0 && blocks[indexBelow] == mod_pocketDim.transientDoor) {
            this.entranceDoorLocation = this.schematic.calculatePoint(index);
            this.entranceOrientation = metadata[indexBelow] & 3;
            return true;
        }
        if (blocks[index] == mod_pocketDim.warpDoor && (indexBelow = this.schematic.calculateIndexBelow(index)) >= 0 && blocks[indexBelow] == mod_pocketDim.warpDoor) {
            this.entranceDoorLocation = this.schematic.calculatePoint(index);
            this.entranceOrientation = metadata[indexBelow] & 3;
            return true;
        }
        return false;
    }

    @Override
    protected boolean terminates() {
        return true;
    }
}

