/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.world.gateways;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonSchematic;
import StevenDimDoors.mod_pocketDim.schematic.InvalidSchematicException;
import StevenDimDoors.mod_pocketDim.world.gateways.BaseGateway;
import StevenDimDoors.mod_pocketDim.world.gateways.GatewayBlockFilter;
import net.minecraft.world.World;

public abstract class BaseSchematicGateway
extends BaseGateway {
    public BaseSchematicGateway(DDProperties properties) {
        super(properties);
    }

    @Override
    public boolean generate(World world, int x, int y, int z) {
        DungeonSchematic schematic;
        try {
            schematic = DungeonSchematic.readFromResource(this.getSchematicPath());
        }
        catch (InvalidSchematicException e) {
            System.err.println("Could not load the schematic for a gateway. The following exception occurred:");
            e.printStackTrace();
            return false;
        }
        GatewayBlockFilter gatewayFilter = new GatewayBlockFilter();
        schematic.applyFilter(gatewayFilter);
        schematic.applyImportFilters(this.properties);
        Point3D doorLocation = gatewayFilter.getEntranceDoorLocation();
        int orientation = gatewayFilter.getEntranceOrientation();
        schematic.copyToWorld(world, x - doorLocation.getX(), y, z - doorLocation.getZ(), true, true);
        this.generateRandomBits(world, x, y, z);
        PocketManager.getDimensionData(world).createLink(x, y + doorLocation.getY(), z, LinkType.DUNGEON, orientation);
        return true;
    }

    protected void generateRandomBits(World world, int x, int y, int z) {
    }

    protected abstract String getSchematicPath();
}

