/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.world;

import StevenDimDoors.experimental.BoundingBox;
import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.blocks.IDimDoor;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonData;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonSchematic;
import StevenDimDoors.mod_pocketDim.dungeon.pack.DungeonPackConfig;
import StevenDimDoors.mod_pocketDim.helpers.DungeonHelper;
import StevenDimDoors.mod_pocketDim.helpers.yCoordHelper;
import StevenDimDoors.mod_pocketDim.items.ItemDimensionalDoor;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.schematic.BlockRotator;
import StevenDimDoors.mod_pocketDim.util.Pair;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.world.PersonalPocketProvider;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.DimensionManager;

public class PocketBuilder {
    public static final int MIN_POCKET_SIZE = 5;
    public static final int MAX_POCKET_SIZE = 51;
    public static final int DEFAULT_POCKET_SIZE = 39;
    public static final int MIN_POCKET_WALL_THICKNESS = 1;
    public static final int MAX_POCKET_WALL_THICKNESS = 10;
    public static final int DEFAULT_POCKET_WALL_THICKNESS = 5;
    private static final Random random = new Random();

    private PocketBuilder() {
    }

    private static boolean buildDungeonPocket(DungeonData dungeon, NewDimData dimension, DimLink link, DungeonSchematic schematic, World world, DDProperties properties) {
        DungeonPackConfig packConfig = dungeon.dungeonType().Owner != null ? dungeon.dungeonType().Owner.getConfig() : null;
        Point4D source = link.source();
        int orientation = link.orientation();
        Point3D destination = packConfig != null && packConfig.doDistortDoorCoordinates() ? PocketBuilder.calculateNoisyDestination(source, dimension, dungeon, orientation) : new Point3D(source.getX(), source.getY(), source.getZ());
        destination.setY(yCoordHelper.adjustDestinationY(destination.getY(), world.func_72800_K(), schematic.getEntranceDoorLocation().getY(), schematic.getHeight()));
        schematic.copyToWorld(world, destination, orientation, link, random, properties, false);
        dimension.initializeDungeon(destination.getX(), destination.getY(), destination.getZ(), orientation, link, dungeon);
        dimension.setFilled(true);
        return true;
    }

    public static boolean generateSelectedDungeonPocket(DimLink link, DDProperties properties, DungeonData dungeon) {
        if (link == null) {
            throw new IllegalArgumentException("link cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        if (link.hasDestination()) {
            throw new IllegalArgumentException("link cannot have a destination assigned already.");
        }
        if (dungeon == null) {
            throw new IllegalArgumentException("dungeon cannot be null.");
        }
        DungeonSchematic schematic = null;
        schematic = PocketBuilder.loadAndValidateDungeon(dungeon, properties);
        if (schematic == null) {
            return false;
        }
        NewDimData parent = PocketManager.getDimensionData(link.source().getDimension());
        NewDimData dimension = PocketManager.registerPocket(parent, DimensionType.DUNGEON);
        WorldServer world = PocketManager.loadDimension(dimension.id());
        if (world == null || world.field_73011_w == null) {
            System.err.println("Could not initialize dimension for a dungeon!");
            return false;
        }
        return PocketBuilder.buildDungeonPocket(dungeon, dimension, link, schematic, (World)world, properties);
    }

    public static boolean generateNewDungeonPocket(DimLink link, DDProperties properties) {
        if (link == null) {
            throw new IllegalArgumentException("link cannot be null.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        if (link.hasDestination()) {
            throw new IllegalArgumentException("link cannot have a destination assigned already.");
        }
        NewDimData parent = PocketManager.getDimensionData(link.source().getDimension());
        Pair<DungeonData, DungeonSchematic> pair = PocketBuilder.selectNextDungeon(parent, random, properties);
        if (pair == null) {
            System.err.println("Could not select a dungeon for generation!");
            return false;
        }
        DungeonData dungeon = pair.getFirst();
        DungeonSchematic schematic = pair.getSecond();
        NewDimData dimension = PocketManager.registerPocket(parent, DimensionType.DUNGEON);
        WorldServer world = PocketManager.loadDimension(dimension.id());
        if (world == null || world.field_73011_w == null) {
            System.err.println("Could not initialize dimension for a dungeon!");
            return false;
        }
        return PocketBuilder.buildDungeonPocket(dungeon, dimension, link, schematic, (World)world, properties);
    }

    private static Point3D calculateNoisyDestination(Point4D source, NewDimData dimension, DungeonData dungeon, int orientation) {
        int depth = NewDimData.calculatePackDepth(dimension.parent(), dungeon);
        int forwardNoise = MathHelper.func_76136_a((Random)random, (int)(10 * depth), (int)(130 * depth));
        int sidewaysNoise = MathHelper.func_76136_a((Random)random, (int)(-10 * depth), (int)(10 * depth));
        Point3D linkDestination = new Point3D(forwardNoise, 0, sidewaysNoise);
        Point3D sourcePoint = new Point3D(source.getX(), source.getY(), source.getZ());
        Point3D zeroPoint = new Point3D(0, 0, 0);
        BlockRotator.transformPoint(linkDestination, zeroPoint, orientation - 0, sourcePoint);
        return linkDestination;
    }

    private static Pair<DungeonData, DungeonSchematic> selectNextDungeon(NewDimData parent, Random random, DDProperties properties) {
        DungeonData dungeon = null;
        DungeonSchematic schematic = null;
        dungeon = DungeonHelper.instance().selectNextDungeon(parent, random);
        if (dungeon != null) {
            schematic = PocketBuilder.loadAndValidateDungeon(dungeon, properties);
        } else {
            System.err.println("Could not select a dungeon at all!");
        }
        if (schematic == null) {
            try {
                System.err.println("Loading the default error dungeon instead...");
                dungeon = DungeonHelper.instance().getDefaultErrorDungeon();
                schematic = PocketBuilder.loadAndValidateDungeon(dungeon, properties);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new Pair<DungeonData, DungeonSchematic>(dungeon, schematic);
    }

    private static DungeonSchematic loadAndValidateDungeon(DungeonData dungeon, DDProperties properties) {
        try {
            DungeonSchematic schematic = dungeon.loadSchematic();
            if (PocketBuilder.hasValidDimensions(schematic)) {
                schematic.applyImportFilters(properties);
                if (schematic.getEntranceDoorLocation() == null) {
                    System.err.println("The following schematic file does not have an entrance: " + dungeon.schematicPath());
                    return null;
                }
            } else {
                System.err.println("The following schematic file has dimensions that exceed the maximum permitted dimensions for dungeons: " + dungeon.schematicPath());
                return null;
            }
            return schematic;
        }
        catch (Exception e) {
            System.err.println("An error occurred while loading the following schematic: " + dungeon.schematicPath());
            System.err.println(e.getMessage());
            return null;
        }
    }

    private static boolean hasValidDimensions(DungeonSchematic schematic) {
        return schematic.getWidth() <= 101 && schematic.getHeight() <= 101 && schematic.getLength() <= 101;
    }

    public static boolean generateNewPocket(DimLink link, DDProperties properties, Block door, DimensionType type) {
        return PocketBuilder.generateNewPocket(link, 39, 5, properties, door, type);
    }

    private static int getDoorOrientation(Point4D source, DDProperties properties) {
        WorldServer world = DimensionManager.getWorld((int)source.getDimension());
        if (world == null) {
            throw new IllegalStateException("The link's source world should be loaded!");
        }
        Block block = world.func_147439_a(source.getX(), source.getY() - 1, source.getZ());
        if (block == null || !(block instanceof IDimDoor)) {
            throw new IllegalStateException("The link's source is not a door block. It should be impossible to traverse a rift without a door!");
        }
        int orientation = world.func_72805_g(source.getX(), source.getY() - 1, source.getZ()) & 3;
        return orientation;
    }

    public static void validatePocketSetup(DimLink link, int size, int wallThickness, DDProperties properties, Block door) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        if (link.linkType() != LinkType.PERSONAL && link.hasDestination()) {
            throw new IllegalArgumentException("link cannot have a destination assigned already.");
        }
        if (door == null) {
            throw new IllegalArgumentException("Must have a doorItem to gen one!!");
        }
        if (size < 5 || size > 51) {
            throw new IllegalArgumentException("size must be between 5 and 51, inclusive.");
        }
        if (wallThickness < 1 || wallThickness > 10) {
            throw new IllegalArgumentException("wallThickness must be between 1 and 10, inclusive.");
        }
        if (size % 2 == 0) {
            throw new IllegalArgumentException("size must be an odd number.");
        }
        if (size < 2 * wallThickness + 3) {
            throw new IllegalArgumentException("size must be large enough to fit the specified wall thickness and some air space.");
        }
    }

    public static boolean generateNewPersonalPocket(DimLink link, DDProperties properties, EntityPlayer player, Block door) {
        if (!(player instanceof EntityPlayer)) {
            return false;
        }
        int wallThickness = 5;
        int size = 39;
        PocketBuilder.validatePocketSetup(link, size, wallThickness, properties, door);
        try {
            NewDimData parent = PocketManager.getDimensionData(link.source().getDimension());
            NewDimData dimension = PocketManager.registerPocket(parent, DimensionType.PERSONAL, player.func_146103_bH().getId().toString());
            WorldServer world = PocketManager.loadDimension(dimension.id());
            if (world == null || world.field_73011_w == null) {
                System.err.println("Could not initialize dimension for a pocket!");
                return false;
            }
            Point4D source = link.source();
            int destinationY = yCoordHelper.adjustDestinationY(link.source().getY(), world.func_72800_K(), wallThickness + 1, size);
            int orientation = PocketBuilder.getDoorOrientation(source, properties);
            DimLink reverseLink = dimension.createLink(source.getX(), destinationY, source.getZ(), LinkType.REVERSE, (link.orientation() + 2) % 4);
            parent.setLinkDestination(reverseLink, source.getX(), source.getY(), source.getZ());
            PocketBuilder.buildPocket((World)world, source.getX(), destinationY, source.getZ(), orientation, size, wallThickness, properties, door);
            dimension.initializePocket(source.getX(), destinationY, source.getZ(), orientation, link);
            dimension.setFilled(true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean generateNewPocket(DimLink link, int size, int wallThickness, DDProperties properties, Block door, DimensionType type) {
        PocketBuilder.validatePocketSetup(link, size, wallThickness, properties, door);
        try {
            NewDimData parent = PocketManager.getDimensionData(link.source().getDimension());
            NewDimData dimension = PocketManager.registerPocket(parent, type);
            WorldServer world = PocketManager.loadDimension(dimension.id());
            if (world == null || world.field_73011_w == null) {
                System.err.println("Could not initialize dimension for a pocket!");
                return false;
            }
            Point4D source = link.source();
            int destinationY = yCoordHelper.adjustDestinationY(source.getY(), world.func_72800_K(), wallThickness + 1, size);
            int orientation = PocketBuilder.getDoorOrientation(source, properties);
            DimLink reverseLink = dimension.createLink(source.getX(), destinationY, source.getZ(), LinkType.REVERSE, (link.orientation() + 2) % 4);
            parent.setLinkDestination(reverseLink, source.getX(), source.getY(), source.getZ());
            PocketBuilder.buildPocket((World)world, source.getX(), destinationY, source.getZ(), orientation, size, wallThickness, properties, door);
            dimension.initializePocket(source.getX(), destinationY, source.getZ(), orientation, link);
            dimension.setFilled(true);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void buildPocket(World world, int x, int y, int z, int orientation, int size, int wallThickness, DDProperties properties, Block doorBlock) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        if (size < 5 || size > 51) {
            throw new IllegalArgumentException("size must be between 5 and 51, inclusive.");
        }
        if (wallThickness < 1 || wallThickness > 10) {
            throw new IllegalArgumentException("wallThickness must be between 1 and 10, inclusive.");
        }
        if (size % 2 == 0) {
            throw new IllegalArgumentException("size must be an odd number.");
        }
        if (size < 2 * wallThickness + 3) {
            throw new IllegalArgumentException("size must be large enough to fit the specified wall thickness and some air space.");
        }
        if (!(doorBlock instanceof IDimDoor)) {
            throw new IllegalArgumentException("Door must implement IDimDoor");
        }
        Point3D center = new Point3D(x - wallThickness + 1 + size / 2, y - wallThickness - 1 + size / 2, z);
        Point3D door = new Point3D(x, y, z);
        BlockRotator.transformPoint(center, door, orientation - 0, door);
        PocketBuilder.buildBox(world, center.getX(), center.getY(), center.getZ(), size / 2, mod_pocketDim.blockDimWallPerm, 0, false, 0);
        int metadata = 0;
        if (world.field_73011_w instanceof PersonalPocketProvider) {
            metadata = 2;
        }
        for (int layer = 1; layer < wallThickness; ++layer) {
            PocketBuilder.buildBox(world, center.getX(), center.getY(), center.getZ(), size / 2 - layer, mod_pocketDim.blockDimWall, metadata, layer < wallThickness - 1 && properties.TNFREAKINGT_Enabled, properties.NonTntWeight);
        }
        int doorOrientation = BlockRotator.transformMetadata(0, orientation - 0 + 2, doorBlock);
        ItemDimensionalDoor.func_150924_a((World)world, (int)x, (int)(y - 1), (int)z, (int)doorOrientation, (Block)doorBlock);
    }

    private static void buildBox(World world, int centerX, int centerY, int centerZ, int radius, Block block, int metadata, boolean placeTnt, int nonTntWeight) {
        int y;
        int z;
        int startX = centerX - radius;
        int startY = centerY - radius;
        int startZ = centerZ - radius;
        int endX = centerX + radius;
        int endY = centerY + radius;
        int endZ = centerZ + radius;
        for (int x = startX; x <= endX; ++x) {
            for (z = startZ; z <= endZ; ++z) {
                PocketBuilder.setBlockDirectlySpecial(world, x, startY, z, block, metadata, placeTnt, nonTntWeight);
                PocketBuilder.setBlockDirectlySpecial(world, x, endY, z, block, metadata, placeTnt, nonTntWeight);
            }
            for (y = startY; y <= endY; ++y) {
                PocketBuilder.setBlockDirectlySpecial(world, x, y, startZ, block, metadata, placeTnt, nonTntWeight);
                PocketBuilder.setBlockDirectlySpecial(world, x, y, endZ, block, metadata, placeTnt, nonTntWeight);
            }
        }
        for (y = startY; y <= endY; ++y) {
            for (z = startZ; z <= endZ; ++z) {
                PocketBuilder.setBlockDirectlySpecial(world, startX, y, z, block, metadata, placeTnt, nonTntWeight);
                PocketBuilder.setBlockDirectlySpecial(world, endX, y, z, block, metadata, placeTnt, nonTntWeight);
            }
        }
    }

    private static void setBlockDirectlySpecial(World world, int x, int y, int z, Block block, int metadata, boolean placeTnt, int nonTntWeight) {
        if (placeTnt && random.nextInt(nonTntWeight + 1) == 0) {
            PocketBuilder.setBlockDirectly(world, x, y, z, Blocks.field_150335_W, 1);
        } else {
            PocketBuilder.setBlockDirectly(world, x, y, z, block, metadata);
        }
    }

    private static void setBlockDirectly(World world, int x, int y, int z, Block block, int metadata) {
        int cX = x >> 4;
        int cZ = z >> 4;
        int cY = y >> 4;
        int localX = x % 16 < 0 ? x % 16 + 16 : x % 16;
        int localZ = z % 16 < 0 ? z % 16 + 16 : z % 16;
        Chunk chunk = world.func_72964_e(cX, cZ);
        ExtendedBlockStorage extBlockStorage = chunk.func_76587_i()[cY];
        if (extBlockStorage == null) {
            chunk.func_76587_i()[cY] = extBlockStorage = new ExtendedBlockStorage(cY << 4, !world.field_73011_w.field_76576_e);
        }
        extBlockStorage.func_150818_a(localX, y & 0xF, localZ, block);
        extBlockStorage.func_76654_b(localX, y & 0xF, localZ, metadata);
        chunk.func_76630_e();
    }

    public static BoundingBox calculateDefaultBounds(NewDimData pocket) {
        int minX = 0;
        int minZ = 0;
        Point4D origin = pocket.origin();
        int orientation = pocket.orientation();
        if (orientation < 0 || orientation > 3) {
            throw new IllegalArgumentException("pocket has an invalid orientation value.");
        }
        switch (orientation) {
            case 0: {
                minX = origin.getX() - 5 + 1;
                minZ = origin.getZ() - 19;
                break;
            }
            case 1: {
                minX = origin.getX() - 19;
                minZ = origin.getZ() - 5 + 1;
                break;
            }
            case 2: {
                minX = origin.getX() + 5 - 39;
                minZ = origin.getZ() - 19;
                break;
            }
            case 3: {
                minX = origin.getX() - 19;
                minZ = origin.getZ() + 5 - 39;
            }
        }
        return new BoundingBox(minX, 0, minZ, 39, 255, 39);
    }
}

