/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.world;

import StevenDimDoors.mod_pocketDim.CloudRenderBlank;
import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.ticking.CustomLimboPopulator;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.world.LimboGenerator;
import StevenDimDoors.mod_pocketDim.world.LimboSkyProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManagerHell;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class LimboProvider
extends WorldProvider {
    private IRenderHandler skyRenderer;
    private DDProperties properties;
    private CustomLimboPopulator spawner;

    public String func_80007_l() {
        return "Limbo";
    }

    public LimboProvider() {
        this.field_76576_e = false;
        this.skyRenderer = new LimboSkyProvider();
        this.spawner = mod_pocketDim.spawner;
        this.properties = mod_pocketDim.properties;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return this.skyRenderer;
    }

    protected void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerHell(mod_pocketDim.limboBiome, 1.0f);
    }

    public BiomeGenBase getBiomeGenForCoords(int x, int z) {
        return mod_pocketDim.limboBiome;
    }

    public boolean func_76567_e() {
        return this.properties.HardcoreLimboEnabled;
    }

    public boolean isBlockHighHumidity(int x, int y, int z) {
        return false;
    }

    public boolean canSnowAt(int x, int y, int z, boolean checkLight) {
        return false;
    }

    protected void func_76556_a() {
        float modifier = 0.0f;
        for (int steps = 0; steps <= 15; ++steps) {
            float var3 = 1.0f - (float)steps / 15.0f;
            this.field_76573_f[steps] = ((0.0f + var3) / (var3 * 3.0f + 1.0f) * (1.0f - modifier) + modifier) * 3.0f;
        }
    }

    public ChunkCoordinates getSpawnPoint() {
        return this.getRandomizedSpawnPoint();
    }

    public float func_76563_a(long par1, float par3) {
        int var4 = (int)(par1 % 24000L);
        float var5 = ((float)var4 + par3) / 24000.0f - 0.25f;
        if (var5 < 0.0f) {
            var5 += 1.0f;
        }
        if (var5 > 1.0f) {
            var5 -= 1.0f;
        }
        float var6 = var5;
        var5 = 1.0f - (float)((Math.cos((double)var5 * Math.PI) + 1.0) / 2.0);
        var5 = var6 + (var5 - var6) / 3.0f;
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMoonPhase(long par1, float par3) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public String getSaveFolder() {
        return this.field_76574_g == 0 ? null : "DimensionalDoors/Limbo" + this.field_76574_g;
    }

    public boolean func_76566_a(int par1, int par2) {
        Block block = this.field_76579_a.func_147474_b(par1, par2);
        return block == mod_pocketDim.blockLimbo;
    }

    public double getHorizon() {
        return this.field_76579_a.func_72800_K() / 4 - 800;
    }

    public Vec3 getSkyColor(Entity cameraEntity, float partialTicks) {
        this.setCloudRenderer(new CloudRenderBlank());
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float par1, float par2) {
        return Vec3.func_72443_a((double)0.2, (double)0.2, (double)0.2);
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return 0;
    }

    public IChunkProvider func_76555_c() {
        return new LimboGenerator(this.field_76579_a, 45L, this.spawner, this.properties);
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean byWater) {
        return false;
    }

    public static Point4D getLimboSkySpawn(EntityPlayer player, DDProperties properties) {
        int x = (int)player.field_70165_t + MathHelper.func_76136_a((Random)player.field_70170_p.field_73012_v, (int)(-properties.LimboEntryRange), (int)properties.LimboEntryRange);
        int z = (int)player.field_70161_v + MathHelper.func_76136_a((Random)player.field_70170_p.field_73012_v, (int)(-properties.LimboEntryRange), (int)properties.LimboEntryRange);
        return new Point4D(x, 700, z, properties.LimboDimensionID);
    }

    public ChunkCoordinates getRandomizedSpawnPoint() {
        int x = MathHelper.func_76136_a((Random)this.field_76579_a.field_73012_v, (int)-500, (int)500);
        int z = MathHelper.func_76136_a((Random)this.field_76579_a.field_73012_v, (int)-500, (int)500);
        return new ChunkCoordinates(x, 700, z);
    }
}

