/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.world;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;

public class LimboDecay {
    private static final int MAX_DECAY_SPREAD_CHANCE = 100;
    private static final int DECAY_SPREAD_CHANCE = 50;
    private static final int CHUNK_SIZE = 16;
    private static final int SECTION_HEIGHT = 16;
    private Block[] decaySequence = null;
    private final Random random;
    private final DDProperties properties;
    private Block[] blocksImmuneToDecay = null;

    public LimboDecay(DDProperties properties) {
        this.properties = properties;
        this.random = new Random();
    }

    public Block[] getDecaySequence() {
        if (this.decaySequence == null) {
            this.decaySequence = new Block[]{mod_pocketDim.blockLimbo, Blocks.field_150351_n, Blocks.field_150347_e, Blocks.field_150348_b};
        }
        return this.decaySequence;
    }

    public Block[] getBlocksImmuneToDecay() {
        if (this.blocksImmuneToDecay == null) {
            this.blocksImmuneToDecay = new Block[]{mod_pocketDim.blockLimbo, mod_pocketDim.blockDimWallPerm, mod_pocketDim.transientDoor, mod_pocketDim.dimensionalDoor, mod_pocketDim.warpDoor, mod_pocketDim.blockRift, mod_pocketDim.unstableDoor, mod_pocketDim.goldenDoor, mod_pocketDim.goldenDimensionalDoor};
        }
        return this.blocksImmuneToDecay;
    }

    public void applySpreadDecay(World world, int x, int y, int z) {
        if (this.random.nextInt(100) < 50) {
            this.decayBlock(world, x - 1, y, z);
            this.decayBlock(world, x + 1, y, z);
            this.decayBlock(world, x, y, z - 1);
            this.decayBlock(world, x, y, z + 1);
            this.decayBlock(world, x, y - 1, z);
            this.decayBlock(world, x, y + 1, z);
        }
    }

    public void applyRandomFastDecay() {
        WorldServer limbo = DimensionManager.getWorld((int)this.properties.LimboDimensionID);
        if (limbo != null) {
            int limboHeight = limbo.func_72800_K();
            Iterator i$ = ForgeChunkManager.getPersistentChunksFor((World)limbo).keySet().iterator();
            while (i$.hasNext()) {
                ChunkCoordIntPair coordObject;
                ChunkCoordIntPair chunkCoord = coordObject = (ChunkCoordIntPair)i$.next();
                for (int sectionY = 0; sectionY < limboHeight; sectionY += 16) {
                    int x = chunkCoord.field_77276_a * 16 + this.random.nextInt(16);
                    int z = chunkCoord.field_77275_b * 16 + this.random.nextInt(16);
                    int y = sectionY + this.random.nextInt(16);
                    this.decayBlockFast((World)limbo, x, y, z);
                }
            }
        }
    }

    private boolean decayBlockFast(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (this.canDecayBlock(block, world, x, y, z)) {
            world.func_147449_b(x, y, z, mod_pocketDim.blockLimbo);
            return true;
        }
        return false;
    }

    private boolean decayBlock(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (this.canDecayBlock(block, world, x, y, z)) {
            int index;
            for (index = 0; index < this.getDecaySequence().length && this.getDecaySequence()[index] != block; ++index) {
            }
            world.func_147449_b(x, y, z, this.getDecaySequence()[index - 1]);
            return true;
        }
        return false;
    }

    private boolean canDecayBlock(Block block, World world, int x, int y, int z) {
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return false;
        }
        for (int k = 0; k < this.getBlocksImmuneToDecay().length; ++k) {
            if (block != this.getBlocksImmuneToDecay()[k]) continue;
            return false;
        }
        return block == null || !(block instanceof BlockContainer);
    }
}

