/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.watcher;

import StevenDimDoors.mod_pocketDim.core.DDLock;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ClientLinkData {
    public final Point4D point;
    public final DDLock lock;
    public final LinkType type;

    public ClientLinkData(DimLink link) {
        this.point = link.source();
        this.type = link.linkType();
        this.lock = link.hasLock() ? link.getLock() : null;
    }

    public ClientLinkData(Point4D point, LinkType type, DDLock lock) {
        this.point = point;
        this.lock = lock;
        this.type = type;
    }

    public void write(ByteBuf output) throws IOException {
        Point4D.write(this.point, output);
        output.writeInt(this.type.index);
        boolean hasLock = this.lock != null;
        output.writeBoolean(hasLock);
        if (hasLock) {
            output.writeBoolean(this.lock.getLockState());
            output.writeInt(this.lock.getLockKey());
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("Type", this.type.index);
        if (this.lock != null) {
            NBTTagCompound lock = new NBTTagCompound();
            lock.func_74757_a("State", this.lock.getLockState());
            lock.func_74768_a("Key", this.lock.getLockKey());
            tag.func_74782_a("Lock", (NBTBase)lock);
        }
        if (this.point != null) {
            NBTTagCompound point = new NBTTagCompound();
            Point4D.writeToNBT(this.point, point);
            tag.func_74782_a("Point", (NBTBase)point);
        }
    }

    public static ClientLinkData read(ByteBuf input) throws IOException {
        Point4D point = Point4D.read(input);
        LinkType type = LinkType.getLinkTypeFromIndex(input.readInt());
        DDLock lock = null;
        if (input.readBoolean()) {
            lock = new DDLock(input.readBoolean(), input.readInt());
        }
        return new ClientLinkData(point, type, lock);
    }

    public static ClientLinkData readFromNBT(NBTTagCompound tag) {
        LinkType type = LinkType.getLinkTypeFromIndex(tag.func_74762_e("Type"));
        Point4D point = null;
        if (tag.func_74764_b("Point")) {
            point = Point4D.readFromNBT(tag.func_74775_l("Point"));
        }
        DDLock lock = null;
        if (tag.func_74764_b("Lock")) {
            NBTTagCompound lockTag = tag.func_74775_l("Lock");
            lock = new DDLock(lockTag.func_74767_n("State"), lockTag.func_74762_e("Key"));
        }
        return new ClientLinkData(point, type, lock);
    }
}

