/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.watcher;

import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientDimData {
    public final int ID;
    public final int rootID;
    public final DimensionType type;

    public ClientDimData(int id, int rootID, DimensionType type) {
        this.ID = id;
        this.rootID = rootID;
        this.type = type;
    }

    public ClientDimData(NewDimData dimension) {
        this.ID = dimension.id();
        this.rootID = dimension.root().id();
        this.type = dimension.type();
    }

    public void write(ByteBuf output) throws IOException {
        output.writeInt(this.ID);
        output.writeInt(this.rootID);
        output.writeInt(this.type.index);
    }

    public static ClientDimData read(ByteBuf input) throws IOException {
        int id = input.readInt();
        int rootID = input.readInt();
        int index = input.readInt();
        return new ClientDimData(id, rootID, DimensionType.getTypeFromIndex(index));
    }
}

