/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.util;

import StevenDimDoors.mod_pocketDim.Point3D;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public final class Point4D
implements Comparable<Point4D> {
    private final int x;
    private final int y;
    private final int z;
    private final int dimension;

    public Point4D(int x, int y, int z, int dimension) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dimension = dimension;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getDimension() {
        return this.dimension;
    }

    public int hashCode() {
        int bit;
        int hash = 0;
        int index = 0;
        for (bit = 0; bit < 8; ++bit) {
            hash |= (this.y >> bit & 1) << index;
            hash |= (this.x >> bit & 1) << ++index;
            hash |= (this.z >> bit & 1) << ++index;
            ++index;
        }
        while (bit < 12) {
            hash |= (this.x >> bit & 1) << index;
            hash |= (this.z >> bit & 1) << ++index;
            ++index;
            ++bit;
        }
        return hash;
    }

    public long toSeed() {
        int bit;
        int w = this.dimension;
        int x = this.x;
        int y = this.y;
        int z = this.z;
        long hash = 0L;
        int index = 48;
        for (bit = 0; bit < 8; ++bit) {
            hash |= (long)(w >> bit & 1) << index;
            hash |= (long)(x >> bit & 1) << --index;
            hash |= (long)(y >> bit & 1) << --index;
            hash |= (long)(z >> bit & 1) << --index;
            --index;
        }
        while (bit < 16) {
            hash |= (long)(x >> bit & 1) << index;
            hash |= (long)(z >> bit & 1) << --index;
            --index;
            ++bit;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        return this.equals((Point4D)obj);
    }

    public Point3D toPoint3D() {
        return new Point3D(this.x, this.y, this.z);
    }

    public int[] toIntArray() {
        return new int[]{this.x, this.y, this.z, this.dimension};
    }

    public boolean equals(Point4D other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.x == other.x && this.y == other.y && this.z == other.z && this.dimension == other.dimension;
    }

    @Override
    public int compareTo(Point4D other) {
        int diff = this.x - other.x;
        if (diff != 0) {
            return diff;
        }
        diff = this.y - other.y;
        if (diff != 0) {
            return diff;
        }
        diff = this.z - other.z;
        if (diff != 0) {
            return diff;
        }
        return this.dimension - other.dimension;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.dimension + ")";
    }

    public static void writeToNBT(Point4D point, NBTTagCompound tag) {
        if (point != null) {
            tag.func_74768_a("X", point.x);
            tag.func_74768_a("Y", point.y);
            tag.func_74768_a("Z", point.z);
            tag.func_74768_a("Dimension", point.dimension);
        }
    }

    public static void write(Point4D point, ByteBuf stream) throws IOException {
        stream.writeBoolean(point != null);
        if (point != null) {
            stream.writeInt(point.x);
            stream.writeInt(point.y);
            stream.writeInt(point.z);
            stream.writeInt(point.dimension);
        }
    }

    public static Point4D read(ByteBuf stream) throws IOException {
        if (stream.readBoolean()) {
            return new Point4D(stream.readInt(), stream.readInt(), stream.readInt(), stream.readInt());
        }
        return null;
    }

    public static Point4D readFromNBT(NBTTagCompound tag) {
        return new Point4D(tag.func_74762_e("X"), tag.func_74762_e("Y"), tag.func_74762_e("Z"), tag.func_74762_e("Dimension"));
    }
}

