/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JSONValidator {
    public static final String TYPE = "type";
    public static final String ANY = "any";
    public static final String PROPERTIES = "properties";
    public static final String OPTIONAL = "optional";
    public static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    public static final String MIN_LENGTH = "minLength";
    public static final String MAX_LENGTH = "maxLength";
    public static final String MINIMUM = "minimum";
    public static final String MAXIMUM = "maximum";
    public static final String PATTERN = "pattern";
    public static final String ITEMS = "items";
    public static final String ENUM = "enum";
    public static final String REQUIRED = "required";
    JsonObject schema;

    public JsonObject getSchema() {
        return this.schema;
    }

    public JSONValidator(JsonObject schema) {
        this.schema = schema;
    }

    static Set<Type> anyTypeSet() {
        HashSet<Type> hashSet = new HashSet<Type>();
        hashSet.add(Type.STRING);
        hashSet.add(Type.NUMBER);
        hashSet.add(Type.INTEGER);
        hashSet.add(Type.BOOLEAN);
        hashSet.add(Type.OBJECT);
        hashSet.add(Type.ARRAY);
        hashSet.add(Type.NULL);
        return hashSet;
    }

    static Set<Type> getSimpleType(String path, String type) {
        for (Type t : Type.values()) {
            if (!t.getTypeString().equals(type)) continue;
            if (t != Type.NUMBER) {
                return Collections.singleton(t);
            }
            HashSet<Type> set = new HashSet<Type>();
            set.add(Type.NUMBER);
            set.add(Type.INTEGER);
            return set;
        }
        if (ANY.equals(type)) {
            return JSONValidator.anyTypeSet();
        }
        return JSONValidator.anyTypeSet();
    }

    static Set<Type> getTypeSet(String path, JsonObject schema) throws JsonParseException {
        JsonPrimitive primitive;
        JsonElement typeElement = schema.get(TYPE);
        if (typeElement == null) {
            return JSONValidator.anyTypeSet();
        }
        if (typeElement.isJsonPrimitive() && (primitive = typeElement.getAsJsonPrimitive()).isString()) {
            return JSONValidator.getSimpleType(path, primitive.getAsString());
        }
        if (typeElement.isJsonArray()) {
            HashSet<Type> set = new HashSet<Type>();
            JsonArray array = typeElement.getAsJsonArray();
            Iterator i$ = array.iterator();
            if (i$.hasNext()) {
                JsonPrimitive primitive2;
                JsonElement element = (JsonElement)i$.next();
                if (element.isJsonPrimitive() && (primitive2 = element.getAsJsonPrimitive()).isString()) {
                    set.addAll(JSONValidator.getSimpleType(path, primitive2.getAsString()));
                }
                return JSONValidator.anyTypeSet();
            }
        }
        return JSONValidator.anyTypeSet();
    }

    static Type getType(JsonElement element) {
        if (element.isJsonArray()) {
            return Type.ARRAY;
        }
        if (element.isJsonObject()) {
            return Type.OBJECT;
        }
        if (element.isJsonNull()) {
            return Type.NULL;
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (primitive.isString()) {
            return Type.STRING;
        }
        if (primitive.isBoolean()) {
            return Type.BOOLEAN;
        }
        if (primitive.isNumber()) {
            BigDecimal decimal = primitive.getAsBigDecimal();
            int scale = decimal.scale();
            if (scale > 0) {
                return Type.NUMBER;
            }
            return Type.INTEGER;
        }
        return Type.STRING;
    }

    static void validateObject(String path, JsonObject schema, JsonObject obj) throws JsonParseException {
        HashSet<String> propertiesSeen = new HashSet<String>();
        JsonArray required = schema.getAsJsonArray(REQUIRED);
        JsonObject properties = schema.getAsJsonObject(PROPERTIES);
        if (properties == null) {
            return;
        }
        Set propertySet = properties.entrySet();
        ArrayList<String> requiredFields = new ArrayList<String>();
        for (JsonElement st : required.getAsJsonArray()) {
            requiredFields.add(st.getAsString());
        }
        for (Map.Entry property : propertySet) {
            String name = (String)property.getKey();
            String newPath = path + "['" + name + "']";
            JsonElement element = (JsonElement)property.getValue();
            propertiesSeen.add(name);
            if (!element.isJsonObject()) {
                throw new JsonParseException("Bad Schema: property definition not an object at '" + newPath + "'");
            }
            JsonObject definition = element.getAsJsonObject();
            JsonElement newTarget = obj.get(name);
            if (newTarget == null) {
                JsonPrimitive optional = definition.getAsJsonPrimitive(OPTIONAL);
                boolean needed = optional == null && requiredFields.contains(name) || optional != null && !optional.getAsBoolean();
                if (!needed) continue;
                throw new JsonParseException("Invalid: Required property '" + newPath + "' not found");
            }
            JSONValidator.validate(newPath, definition, newTarget);
        }
        JsonElement additionalProperties = schema.get(ADDITIONAL_PROPERTIES);
        JsonObject additionalSchema = null;
        if (additionalProperties == null) {
            additionalSchema = new JsonObject();
        } else if (additionalProperties.isJsonObject()) {
            additionalSchema = additionalProperties.getAsJsonObject();
        }
        Set objectProperties = obj.entrySet();
        for (Map.Entry property : objectProperties) {
            String name = (String)property.getKey();
            String newPath = path + "['" + name + "']";
            if (propertiesSeen.contains(name)) continue;
            if (additionalSchema == null) {
                throw new JsonParseException("Invalid: Found additional property '" + newPath + "'");
            }
            JSONValidator.validate(newPath, additionalSchema, (JsonElement)property.getValue());
        }
    }

    static Integer getInt(String path, String attributeName, JsonObject schema) throws JsonParseException {
        JsonElement attributeElement = schema.get(attributeName);
        if (attributeElement == null) {
            return null;
        }
        if (!attributeElement.isJsonPrimitive()) {
            throw new JsonParseException("Bad Schema: '" + attributeName + "' attribute is not an integer at '" + path + "'");
        }
        JsonPrimitive attributePrimitive = attributeElement.getAsJsonPrimitive();
        if (!attributePrimitive.isNumber()) {
            throw new JsonParseException("Bad Schema: '" + attributeName + "' attribute is not an integer at '" + path + "'");
        }
        return attributePrimitive.getAsInt();
    }

    static String getString(String path, String attributeName, JsonObject schema) throws JsonParseException {
        JsonElement attributeElement = schema.get(attributeName);
        if (attributeElement == null) {
            return null;
        }
        if (!attributeElement.isJsonPrimitive()) {
            throw new JsonParseException("Bad Schema: '" + attributeName + "' attribute is not a string at '" + path + "'");
        }
        JsonPrimitive attributePrimitive = attributeElement.getAsJsonPrimitive();
        if (!attributePrimitive.isString()) {
            throw new JsonParseException("Bad Schema: '" + attributeName + "' attribute is not a string at '" + path + "'");
        }
        return attributePrimitive.getAsString();
    }

    static BigDecimal getBigDecimal(String path, String attributeName, JsonObject schema) throws JsonParseException {
        JsonElement attributeElement = schema.get(attributeName);
        if (attributeElement == null) {
            return null;
        }
        if (!attributeElement.isJsonPrimitive()) {
            throw new JsonParseException("Bad Schema: '" + attributeName + "' attribute is not a number at '" + path + "'");
        }
        JsonPrimitive attributePrimitive = attributeElement.getAsJsonPrimitive();
        if (!attributePrimitive.isNumber()) {
            throw new JsonParseException("Bad Schema: '" + attributeName + "' attribute is not a number at '" + path + "'");
        }
        return attributePrimitive.getAsBigDecimal();
    }

    static void validateString(String path, JsonObject schema, String str) throws JsonParseException {
        Integer minLength = JSONValidator.getInt(path, MIN_LENGTH, schema);
        Integer maxLength = JSONValidator.getInt(path, MAX_LENGTH, schema);
        if (minLength != null && str.length() < minLength) {
            throw new JsonParseException("Invalid: String '" + path + "' is too short.  The string needs to be more than " + minLength + " characters");
        }
        if (maxLength != null && str.length() > maxLength) {
            throw new JsonParseException("Invalid: String '" + path + "' is too long.  The string needs to be less than " + maxLength + " characters");
        }
        String pattern = JSONValidator.getString(path, PATTERN, schema);
        if (pattern != null && !str.matches(pattern)) {
            throw new JsonParseException("Invalid: String '" + path + "' does not match pattern '" + pattern + "'");
        }
    }

    static void validateTuple(String path, JsonArray tupleSchema, JsonObject additionalSchema, JsonArray array) throws JsonParseException {
    }

    static void validateArray(String path, JsonObject schema, JsonArray array) throws JsonParseException {
        JsonElement additionalProperties = schema.get(ADDITIONAL_PROPERTIES);
        JsonObject additionalSchema = null;
        if (additionalProperties == null) {
            additionalSchema = new JsonObject();
        } else if (additionalProperties.isJsonObject()) {
            additionalSchema = additionalProperties.getAsJsonObject();
        }
        JsonElement itemsElement = schema.get(ITEMS);
        if (itemsElement == null) {
            return;
        }
        if (itemsElement.isJsonArray()) {
            JSONValidator.validateTuple(path, itemsElement.getAsJsonArray(), additionalSchema, array);
            return;
        }
        JsonObject itemsSchema = null;
        itemsSchema = itemsElement.isJsonObject() ? itemsElement.getAsJsonObject() : new JsonObject();
        int i = 0;
        for (JsonElement element : array) {
            String curPath = path + "[" + ++i + "]";
            JSONValidator.validate(curPath, itemsSchema, element);
        }
    }

    static void validateEnum(String path, JsonObject schema, JsonElement element) throws JsonParseException {
        JsonElement enumElement = schema.get(ENUM);
        if (enumElement == null) {
            return;
        }
        if (!enumElement.isJsonArray()) {
            // empty if block
        }
        JsonArray enumArray = enumElement.getAsJsonArray();
        for (JsonElement curElement : enumArray) {
            if (!element.equals(curElement)) continue;
            return;
        }
        throw new JsonParseException("Invalid: Property '" + path + "' is not one of the enum values.");
    }

    static void validateNumber(String path, JsonObject schema, BigDecimal number) throws JsonParseException {
        BigDecimal minimum = JSONValidator.getBigDecimal(path, MINIMUM, schema);
        if (minimum != null && number.compareTo(minimum) < 0) {
            throw new JsonParseException("Invalid: Property '" + path + "' has a value of '" + number + "' which is less than the minimum of '" + minimum + "'.");
        }
        BigDecimal maximum = JSONValidator.getBigDecimal(path, MAXIMUM, schema);
        if (maximum != null && number.compareTo(maximum) > 0) {
            throw new JsonParseException("Invalid: Property '" + path + "' has a value of '" + number + "' which is greater than the maximum of '" + maximum + "'.");
        }
    }

    static void validate(String path, JsonObject schema, JsonElement element) throws JsonParseException {
        Type type;
        Set<Type> typeSet = JSONValidator.getTypeSet(path, schema);
        if (!typeSet.contains((Object)(type = JSONValidator.getType(element)))) {
            throw WrongType.generate(path, typeSet, type);
        }
        switch (type) {
            case BOOLEAN: 
            case NULL: {
                break;
            }
            case NUMBER: 
            case INTEGER: {
                JSONValidator.validateNumber(path, schema, element.getAsBigDecimal());
                break;
            }
            case ARRAY: {
                JSONValidator.validateArray(path, schema, element.getAsJsonArray());
                break;
            }
            case STRING: {
                JSONValidator.validateString(path, schema, element.getAsString());
                break;
            }
            case OBJECT: {
                JSONValidator.validateObject(path, schema, element.getAsJsonObject());
                break;
            }
            default: {
                throw new JsonParseException("Internal Error");
            }
        }
        JSONValidator.validateEnum(path, schema, element);
    }

    public static void validate(JsonObject schema, JsonElement element) throws JsonParseException {
        JSONValidator.validate("$", schema, element);
    }

    public void validate(JsonElement element) throws JsonParseException {
        JSONValidator.validate(this.getSchema(), element);
    }

    static enum Type {
        STRING("string"),
        NUMBER("number"),
        INTEGER("integer"),
        BOOLEAN("boolean"),
        OBJECT("object"),
        ARRAY("array"),
        NULL("null");

        String typeString;

        private Type(String typeString) {
            this.typeString = typeString;
        }

        public String getTypeString() {
            return this.typeString;
        }
    }

    static class WrongType
    extends JsonParseException {
        private static final long serialVersionUID = 1L;

        WrongType(String msg) {
            super(msg);
        }

        static WrongType generate(String path, Set<Type> types, Type found) {
            boolean first = true;
            String typeList = "'unknown'";
            for (Type type : types) {
                if (first) {
                    typeList = "'" + type.getTypeString() + "'";
                    first = false;
                    continue;
                }
                typeList = typeList + " or '" + type.getTypeString() + "'";
            }
            return new WrongType("Invalid: Expected type " + typeList + " at '" + path + "', but " + "found type '" + found.getTypeString() + "'");
        }
    }
}

