/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.util;

import java.util.HashMap;

public class DDLogger {
    private static DDLogger instance;
    private StringBuilder log;
    private HashMap<String, DDTimer> timers = new HashMap();

    private DDLogger() {
        this.log = new StringBuilder();
        this.log.append("Logger started.\n");
    }

    private static DDLogger logger() {
        if (instance == null) {
            instance = new DDLogger();
        }
        return instance;
    }

    public static void startTimer(String description) {
        DDLogger dDLogger = DDLogger.logger();
        dDLogger.getClass();
        DDTimer timer = dDLogger.new DDTimer(description);
        DDLogger.logger().timers.put(description, timer);
        timer.start();
    }

    public static double stopTimer(String description) {
        long endTime = System.nanoTime();
        DDTimer timer = DDLogger.logger().timers.get(description);
        if (timer == null) {
            return -1.0;
        }
        timer.stop(endTime);
        DDLogger.logger().timers.remove(description);
        return timer.getDuration();
    }

    public String printLog() {
        return this.log.toString();
    }

    public void clearLog() {
        this.log = new StringBuilder();
    }

    private class DDTimer {
        final String description;
        Long startTime;
        Long endTime;
        boolean stopped = false;

        private DDTimer(String description) {
            this.description = description;
        }

        private void start() {
            this.startTime = System.nanoTime();
        }

        private void stop(long endTime) {
            this.endTime = endTime;
            if (!this.stopped) {
                this.stopped = true;
                DDLogger.this.log.append(this.description + " took " + this.getDuration() + " seconds to execute.\n");
            }
        }

        public double getDuration() {
            if (this.stopped) {
                return (double)(this.endTime - this.startTime) / 1.0E9;
            }
            return -1.0;
        }
    }
}

