/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.util;

import StevenDimDoors.mod_pocketDim.util.ConfigurationProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseConfigurationProcessor<T> {
    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public T readFromFile(String path) throws ConfigurationProcessingException, IOException {
        return this.readFromFile(new File(path));
    }

    public T readFromFile(File file) throws ConfigurationProcessingException, IOException {
        FileInputStream t = new FileInputStream(file);
        T ret = this.readFromStream(t);
        t.close();
        return ret;
    }

    public T readFromResource(String resourcePath) throws ConfigurationProcessingException {
        return this.readFromStream(this.getClass().getResourceAsStream(resourcePath));
    }

    public abstract T readFromStream(InputStream var1) throws ConfigurationProcessingException;

    public void writeToFile(File file, T data) throws ConfigurationProcessingException, IOException {
        FileOutputStream t = new FileOutputStream(file);
        this.writeToStream(t, data);
        t.close();
    }

    public void writeToFile(String path, T data) throws ConfigurationProcessingException, IOException {
        this.writeToFile(new File(path), data);
    }

    public abstract void writeToStream(OutputStream var1, T var2) throws ConfigurationProcessingException;
}

