/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.tileentities;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.tileentities.DDTileEntityBase;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.watcher.ClientLinkData;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityRift
extends DDTileEntityBase {
    private static final int RIFT_INTERACTION_RANGE = 5;
    private static final int MAX_ANCESTOR_LINKS = 2;
    private static final int MAX_CHILD_LINKS = 1;
    private static final int ENDERMAN_SPAWNING_CHANCE = 1;
    private static final int MAX_ENDERMAN_SPAWNING_CHANCE = 32;
    private static final int RIFT_SPREAD_CHANCE = 1;
    private static final int MAX_RIFT_SPREAD_CHANCE = 256;
    private static final int HOSTILE_ENDERMAN_CHANCE = 1;
    private static final int MAX_HOSTILE_ENDERMAN_CHANCE = 3;
    private static final int UPDATE_PERIOD = 200;
    private static final int CLOSING_PERIOD = 40;
    private static Random random = new Random();
    private int updateTimer;
    private int closeTimer = 0;
    public int xOffset = 0;
    public int yOffset = 0;
    public int zOffset = 0;
    public boolean shouldClose = false;
    public Point4D nearestRiftLocation = null;
    public int spawnedEndermenID = 0;
    public int riftRotation = random.nextInt(360);
    public float growth = 0.0f;

    public TileEntityRift() {
        this.updateTimer = random.nextInt(200);
    }

    public void func_145845_h() {
        if (PocketManager.getLink(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g) == null) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == mod_pocketDim.blockRift) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                this.func_145843_s();
            }
            return;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) != mod_pocketDim.blockRift) {
            this.func_145843_s();
            return;
        }
        if (this.shouldClose) {
            this.closeRift();
            return;
        }
        if (this.updateTimer >= 200) {
            this.spawnEndermen(mod_pocketDim.properties);
            this.updateTimer = 0;
        } else if (this.updateTimer == 100) {
            this.updateNearestRift();
            this.spread(mod_pocketDim.properties);
        }
        this.growth += 1.0f / (this.growth + 1.0f);
        ++this.updateTimer;
    }

    private void spawnEndermen(DDProperties properties) {
        List list;
        if (this.field_145850_b.field_72995_K || !properties.RiftsSpawnEndermenEnabled) {
            return;
        }
        Entity entity = this.field_145850_b.func_73045_a(this.spawnedEndermenID);
        if (entity != null && entity instanceof EntityEnderman) {
            return;
        }
        if (random.nextInt(32) < 1 && this.updateNearestRift() && (list = this.field_145850_b.func_72872_a(EntityEnderman.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 9), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 9), (double)(this.field_145851_c + 9), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 9)))).isEmpty()) {
            EntityPlayer player;
            EntityEnderman enderman = new EntityEnderman(this.field_145850_b);
            enderman.func_70012_b((double)this.field_145851_c + 0.5, (double)(this.field_145848_d - 1), (double)this.field_145849_e + 0.5, 5.0f, 6.0f);
            this.field_145850_b.func_72838_d((Entity)enderman);
            if (random.nextInt(3) < 1 && (player = this.field_145850_b.func_72890_a((Entity)enderman, 50.0)) != null) {
                enderman.func_70784_b((Entity)player);
            }
        }
    }

    private void closeRift() {
        NewDimData dimension = PocketManager.createDimensionData(this.field_145850_b);
        if (this.growth < 20.0f) {
            for (DimLink riftLink : dimension.findRiftsInRange(this.field_145850_b, 6, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                Point4D location = riftLink.source();
                TileEntityRift rift = (TileEntityRift)this.field_145850_b.func_147438_o(location.getX(), location.getY(), location.getZ());
                if (rift == null || rift.shouldClose) continue;
                rift.shouldClose = true;
                rift.func_70296_d();
            }
        }
        if (this.growth <= 0.0f && !this.field_145850_b.field_72995_K) {
            DimLink link = PocketManager.getLink(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
            if (link != null && !this.field_145850_b.field_72995_K) {
                dimension.deleteLink(link);
            }
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "mods.DimDoors.sfx.riftClose", 0.7f, 1.0f, false);
        }
        this.growth -= 1.0f;
    }

    public boolean updateNearestRift() {
        Point4D previousNearest = this.nearestRiftLocation;
        DimLink nearestRiftLink = PocketManager.createDimensionData(this.field_145850_b).findNearestRift(this.field_145850_b, 5, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Point4D point4D = this.nearestRiftLocation = nearestRiftLink == null ? null : nearestRiftLink.source();
        if (!(previousNearest == this.nearestRiftLocation || previousNearest != null && this.nearestRiftLocation != null && previousNearest.equals(this.nearestRiftLocation))) {
            this.updateParticleOffsets();
        }
        return this.nearestRiftLocation != null;
    }

    private void updateParticleOffsets() {
        if (this.nearestRiftLocation != null) {
            this.xOffset = this.field_145851_c - this.nearestRiftLocation.getX();
            this.yOffset = this.field_145848_d - this.nearestRiftLocation.getY();
            this.zOffset = this.field_145849_e - this.nearestRiftLocation.getZ();
        } else {
            this.xOffset = 0;
            this.yOffset = 0;
            this.xOffset = 0;
        }
        this.func_70296_d();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int countAncestorLinks(DimLink link) {
        if (link.parent() != null) {
            return this.countAncestorLinks(link.parent()) + 1;
        }
        return 0;
    }

    public void spread(DDProperties properties) {
        if (this.field_145850_b.field_72995_K || !properties.RiftSpreadEnabled || random.nextInt(256) < 1 || this.shouldClose) {
            return;
        }
        NewDimData dimension = PocketManager.createDimensionData(this.field_145850_b);
        DimLink link = dimension.getLink(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (link.childCount() >= 1 || this.countAncestorLinks(link) >= 2) {
            return;
        }
        int nearRifts = dimension.findRiftsInRange(this.field_145850_b, 5, this.field_145851_c, this.field_145848_d, this.field_145849_e).size();
        if (nearRifts == 0 || random.nextInt(nearRifts) == 0) {
            return;
        }
        mod_pocketDim.blockRift.spreadRift(dimension, link, this.field_145850_b, random);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.updateTimer = nbt.func_74762_e("updateTimer");
        this.xOffset = nbt.func_74762_e("xOffset");
        this.yOffset = nbt.func_74762_e("yOffset");
        this.zOffset = nbt.func_74762_e("zOffset");
        this.shouldClose = nbt.func_74767_n("shouldClose");
        this.spawnedEndermenID = nbt.func_74762_e("spawnedEndermenID");
        this.riftRotation = nbt.func_74762_e("riftRotation");
        this.growth = nbt.func_74760_g("growth");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("updateTimer", this.updateTimer);
        nbt.func_74768_a("xOffset", this.xOffset);
        nbt.func_74768_a("yOffset", this.yOffset);
        nbt.func_74768_a("zOffset", this.zOffset);
        nbt.func_74757_a("shouldClose", this.shouldClose);
        nbt.func_74768_a("spawnedEndermenID", this.spawnedEndermenID);
        nbt.func_74768_a("riftRotation", this.riftRotation);
        nbt.func_74776_a("growth", this.growth);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        if (PocketManager.getLink(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b) != null) {
            ClientLinkData linkData = new ClientLinkData(PocketManager.getLink(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b));
            NBTTagCompound link = new NBTTagCompound();
            linkData.writeToNBT(link);
            tag.func_74782_a("Link", (NBTBase)link);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        if (tag.func_74764_b("Link")) {
            ClientLinkData linkData = ClientLinkData.readFromNBT(tag.func_74775_l("Link"));
            PocketManager.getLinkWatcher().onCreated(linkData);
        }
    }

    @Override
    public float[] getRenderColor(Random rand) {
        return null;
    }
}

