/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.ticking;

import StevenDimDoors.mod_pocketDim.core.DDTeleporter;
import StevenDimDoors.mod_pocketDim.ticking.IRegularTickReceiver;
import StevenDimDoors.mod_pocketDim.ticking.IRegularTickSender;
import StevenDimDoors.mod_pocketDim.ticking.RegularTickReceiverInfo;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;

public class ServerTickHandler
implements IRegularTickSender {
    private static final String PROFILING_LABEL = "Dimensional Doors: Server Tick";
    private int tickCount = 0;
    private ArrayList<RegularTickReceiverInfo> receivers = new ArrayList();

    @Override
    public void registerReceiver(IRegularTickReceiver receiver, int interval, boolean onTickStart) {
        RegularTickReceiverInfo info = new RegularTickReceiverInfo(receiver, interval, onTickStart);
        this.receivers.add(info);
    }

    @Override
    public void unregisterReceivers() {
        this.receivers.clear();
    }

    @SubscribeEvent
    public void tickEvent(TickEvent event) {
        if (event.side != Side.SERVER) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart(event.type);
        } else if (event.phase == TickEvent.Phase.END) {
            this.tickEnd(event.type);
        }
    }

    private void tickStart(TickEvent.Type type) {
        if (type.equals(EnumSet.of(TickEvent.Type.SERVER))) {
            for (RegularTickReceiverInfo info : this.receivers) {
                if (!info.OnTickStart || this.tickCount % info.Interval != 0) continue;
                info.RegularTickReceiver.notifyTick();
            }
        }
        if (DDTeleporter.cooldown > 0) {
            --DDTeleporter.cooldown;
        }
    }

    private void tickEnd(TickEvent.Type type) {
        for (RegularTickReceiverInfo info : this.receivers) {
            if (info.OnTickStart || this.tickCount % info.Interval != 0) continue;
            info.RegularTickReceiver.notifyTick();
        }
        ++this.tickCount;
    }
}

