/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.ticking;

import StevenDimDoors.mod_pocketDim.blocks.BlockRift;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.ticking.IRegularTickReceiver;
import StevenDimDoors.mod_pocketDim.ticking.IRegularTickSender;
import StevenDimDoors.mod_pocketDim.ticking.RiftTicket;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import java.util.PriorityQueue;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RiftRegenerator
implements IRegularTickReceiver {
    private static final int MIN_FAST_DELAY = 1;
    private static final int MAX_FAST_DELAY = 3;
    private static final int MIN_SLOW_DELAY = 5;
    private static final int MAX_SLOW_DELAY = 15;
    private static final int MIN_RESCHEDULE_DELAY = 240;
    private static final int MAX_RESCHEDULE_DELAY = 360;
    private static final int TICKS_PER_SECOND = 20;
    private static final int RIFT_REGENERATION_INTERVAL = 1;
    private static Random random = new Random();
    private long tickCount = 0L;
    private PriorityQueue<RiftTicket> ticketQueue = new PriorityQueue();
    private BlockRift blockRift;

    public RiftRegenerator(IRegularTickSender sender, BlockRift blockRift) {
        this.blockRift = blockRift;
        sender.registerReceiver(this, 1, false);
    }

    @Override
    public void notifyTick() {
        this.processTicketQueue();
        ++this.tickCount;
    }

    public void scheduleSlowRegeneration(DimLink link) {
        this.scheduleRegeneration(link, 5, 15);
    }

    public void scheduleSlowRegeneration(int x, int y, int z, World world) {
        this.scheduleRegeneration(PocketManager.getLink(x, y, z, world), 5, 15);
    }

    public void scheduleFastRegeneration(int x, int y, int z, World world) {
        this.scheduleRegeneration(PocketManager.getLink(x, y, z, world), 1, 3);
    }

    private void scheduleRegeneration(DimLink link, int minDelay, int maxDelay) {
        if (link != null) {
            int tickDelay = MathHelper.func_76136_a((Random)random, (int)(minDelay * 20), (int)(maxDelay * 20));
            this.ticketQueue.add(new RiftTicket(link.source(), this.tickCount + (long)tickDelay));
        }
    }

    private void processTicketQueue() {
        while (!this.ticketQueue.isEmpty() && this.ticketQueue.peek().timestamp() <= this.tickCount) {
            RiftTicket ticket = (RiftTicket)this.ticketQueue.remove();
            this.regenerateRift(ticket.location());
        }
    }

    private void regenerateRift(Point4D location) {
        int x = location.getX();
        int y = location.getY();
        int z = location.getZ();
        WorldServer world = DimensionManager.getWorld((int)location.getDimension());
        if (world == null) {
            return;
        }
        DimLink link = PocketManager.getLink(location);
        if (link == null) {
            return;
        }
        if (!world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            return;
        }
        if (this.blockRift.isModBlockImmune((World)world, x, y, z)) {
            return;
        }
        if (this.blockRift.isBlockImmune((World)world, x, y, z)) {
            this.scheduleRegeneration(link, 240, 360);
        } else {
            Block block = world.func_147439_a(x, y, z);
            if (world.func_147449_b(x, y, z, (Block)this.blockRift)) {
                this.blockRift.dropWorldThread(block, (World)world, x, y, z, random);
            }
        }
    }
}

