/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.ticking;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.DDTeleporter;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import StevenDimDoors.mod_pocketDim.world.LimboProvider;
import StevenDimDoors.mod_pocketDim.world.PocketProvider;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class MobMonolith
extends EntityFlying
implements IMob {
    private static final short MAX_AGGRO = 250;
    private static final short MAX_AGGRO_CAP = 100;
    private static final short MIN_AGGRO_CAP = 25;
    private static final int MAX_TEXTURE_STATE = 18;
    private static final int MAX_SOUND_COOLDOWN = 200;
    private static final int MAX_AGGRO_RANGE = 35;
    private static final int AGGRO_WATCHER_INDEX = 16;
    private static final float WIDTH = 3.0f;
    private static final float HEIGHT = 3.0f;
    private static final float EYE_HEIGHT = 1.5f;
    public float pitchLevel;
    private short aggro = 0;
    private int soundTime = 0;
    private final short aggroCap;
    private static DDProperties properties = null;

    public MobMonolith(World world) {
        super(world);
        this.func_70105_a(3.0f, 3.0f);
        this.field_70145_X = true;
        this.aggroCap = (short)MathHelper.func_76136_a((Random)this.field_70146_Z, (int)25, (int)100);
        if (properties == null) {
            properties = DDProperties.instance();
        }
    }

    public boolean isDangerous() {
        return MobMonolith.properties.MonolithTeleportationEnabled && (MobMonolith.properties.LimboDimensionID != this.field_70170_p.field_73011_w.field_76574_g || !MobMonolith.properties.DangerousLimboMonolithsDisabled);
    }

    protected void func_70665_d(DamageSource par1DamageSource, float par2) {
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource != DamageSource.field_76368_d) {
            this.aggro = (short)250;
        }
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public boolean func_70692_ba() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a(57005.0);
    }

    public boolean func_70104_M() {
        return false;
    }

    public float func_70047_e() {
        return 1.5f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
    }

    public boolean func_70089_S() {
        return false;
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_73011_w.field_76574_g != MobMonolith.properties.LimboDimensionID && !(this.field_70170_p.field_73011_w instanceof PocketProvider)) {
            this.func_70106_y();
            super.func_70030_z();
            return;
        }
        super.func_70030_z();
        EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 35.0);
        boolean visibility = player != null ? player.func_70685_l((Entity)this) : false;
        this.updateAggroLevel(player, visibility);
        if (player != null) {
            this.facePlayer(player);
            if (!this.field_70170_p.field_72995_K && this.isDangerous()) {
                this.playSounds(player);
            }
            if (visibility) {
                if (this.field_70170_p.field_72995_K && this.isDangerous()) {
                    this.spawnParticles(player);
                }
                if (this.aggro >= 250 && !this.field_70170_p.field_72995_K && MobMonolith.properties.MonolithTeleportationEnabled && !player.field_71075_bZ.field_75098_d && this.isDangerous()) {
                    this.aggro = 0;
                    Point4D destination = LimboProvider.getLimboSkySpawn(player, properties);
                    DDTeleporter.teleportEntity((Entity)player, destination, false);
                    player.field_70170_p.func_72956_a((Entity)player, "dimdoors:crack", 13.0f, 1.0f);
                }
            }
        }
    }

    private void updateAggroLevel(EntityPlayer player, boolean visibility) {
        if (!this.field_70170_p.field_72995_K) {
            if (visibility) {
                this.aggro = this.field_70170_p.field_73011_w.field_76574_g == MobMonolith.properties.LimboDimensionID ? (this.isDangerous() ? (short)(this.aggro + 1) : (short)(this.aggro + 36)) : (short)(this.aggro + 3);
            } else if (this.isDangerous()) {
                if (this.aggro > this.aggroCap) {
                    this.aggro = (short)(this.aggro - 1);
                } else if (player != null && this.aggro < this.aggroCap) {
                    this.aggro = (short)(this.aggro + 1);
                }
            } else {
                this.aggro = (short)(this.aggro - 3);
            }
            int maxAggro = this.isDangerous() ? 250 : 180;
            this.aggro = (short)MathHelper.func_76125_a((int)this.aggro, (int)0, (int)maxAggro);
            this.field_70180_af.func_75692_b(16, (Object)this.aggro);
        } else {
            this.aggro = this.field_70180_af.func_75693_b(16);
        }
    }

    public int getTextureState() {
        return MathHelper.func_76125_a((int)(18 * this.aggro / 250), (int)0, (int)18);
    }

    private void playSounds(EntityPlayer entityPlayer) {
        float aggroPercent = this.getAggroProgress();
        if (this.soundTime <= 0) {
            this.func_85030_a("dimdoors:monk", 1.0f, 1.0f);
            this.soundTime = 100;
        }
        if ((double)aggroPercent > 0.7 && this.soundTime < 100) {
            this.field_70170_p.func_72908_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, "dimdoors:tearing", 1.0f, (float)(1.0 + this.field_70146_Z.nextGaussian()));
            this.soundTime = 100 + this.field_70146_Z.nextInt(75);
        }
        if ((double)aggroPercent > 0.8 && this.soundTime < 200) {
            this.field_70170_p.func_72908_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, "dimdoors:tearing", 7.0f, 1.0f);
            this.soundTime = 250;
        }
        --this.soundTime;
    }

    private void spawnParticles(EntityPlayer player) {
        int count = 10 * this.aggro / 250;
        for (int i = 1; i < count; ++i) {
            player.field_70170_p.func_72869_a("portal", player.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, player.field_70163_u + this.field_70146_Z.nextDouble() * (double)player.field_70131_O - 0.75, player.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)player.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
        }
    }

    public float getAggroProgress() {
        return (float)this.aggro / 250.0f;
    }

    private void facePlayer(EntityPlayer player) {
        double d0 = player.field_70165_t - this.field_70165_t;
        double d1 = player.field_70161_v - this.field_70161_v;
        double d2 = player.field_70163_u + (double)player.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        this.pitchLevel = (float)(-(Math.atan(d2 / d3) * 180.0 / Math.PI));
        this.field_70177_z = f2;
        this.field_70759_as = f2;
        this.field_70761_aq = this.field_70177_z;
    }

    public void func_70014_b(NBTTagCompound rootTag) {
        super.func_70014_b(rootTag);
        rootTag.func_74768_a("Aggro", (int)this.aggro);
    }

    public void func_70037_a(NBTTagCompound rootTag) {
        super.func_70037_a(rootTag);
        this.aggro = (short)(rootTag.func_74762_e("Aggro") / 2);
    }

    public boolean func_70601_bi() {
        List list = this.field_70170_p.func_72839_b((Entity)this, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - 15.0), (double)(this.field_70163_u - 4.0), (double)(this.field_70161_v - 15.0), (double)(this.field_70165_t + 15.0), (double)(this.field_70163_u + 15.0), (double)(this.field_70161_v + 15.0)));
        if (this.field_70170_p.field_73011_w.field_76574_g == DDProperties.instance().LimboDimensionID ? list.size() > 0 : this.field_70170_p.field_73011_w instanceof PocketProvider && (list.size() > 5 || this.field_70170_p.func_72937_j((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v))) {
            return false;
        }
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }
}

