/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.ticking;

import StevenDimDoors.mod_pocketDim.config.DDProperties;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.helpers.yCoordHelper;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.ticking.IRegularTickReceiver;
import StevenDimDoors.mod_pocketDim.ticking.IRegularTickSender;
import StevenDimDoors.mod_pocketDim.ticking.MobMonolith;
import StevenDimDoors.mod_pocketDim.util.ChunkLocation;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CustomLimboPopulator
implements IRegularTickReceiver {
    public static final int MAX_MONOLITH_SPAWNING_CHANCE = 100;
    private static final String MOB_SPAWNING_RULE = "doMobSpawning";
    private static final int MAX_MONOLITH_SPAWN_Y = 245;
    private static final int CHUNK_SIZE = 16;
    private static final int MONOLITH_SPAWNING_INTERVAL = 1;
    private DDProperties properties;
    private ConcurrentLinkedQueue<ChunkLocation> locations;

    public CustomLimboPopulator(IRegularTickSender sender, DDProperties properties) {
        this.properties = properties;
        this.locations = new ConcurrentLinkedQueue();
        sender.registerReceiver(this, 1, false);
    }

    @Override
    public void notifyTick() {
        WorldServer limboWorld = null;
        if (!this.locations.isEmpty()) {
            if (CustomLimboPopulator.isMobSpawningAllowed()) {
                for (ChunkLocation location : this.locations) {
                    if (location.DimensionID == this.properties.LimboDimensionID) {
                        if (limboWorld == null) {
                            limboWorld = PocketManager.loadDimension(this.properties.LimboDimensionID);
                        }
                        this.placeMonolithsInLimbo((World)limboWorld, location.ChunkX, location.ChunkZ);
                        mod_pocketDim.gatewayGenerator.generate(limboWorld.field_73012_v, location.ChunkX, location.ChunkZ, (World)limboWorld, limboWorld.func_72863_F(), limboWorld.func_72863_F());
                        continue;
                    }
                    this.placeMonolithsInPocket(location.DimensionID, location.ChunkX, location.ChunkZ);
                }
            }
            this.locations.clear();
        }
    }

    public void registerChunkForPopulation(int dimensionID, int chunkX, int chunkZ) {
        ChunkLocation location = new ChunkLocation(dimensionID, chunkX, chunkZ);
        this.locations.add(location);
    }

    private void placeMonolithsInPocket(int dimensionID, int chunkX, int chunkZ) {
        NewDimData dimension = PocketManager.getDimensionData(dimensionID);
        WorldServer pocket = DimensionManager.getWorld((int)dimensionID);
        if (pocket == null || dimension == null || dimension.dungeon() == null || dimension.dungeon().isOpen()) {
            return;
        }
        int sanity = 0;
        Block block = Blocks.field_150350_a;
        boolean didSpawn = false;
        Random random = new Random(pocket.func_72905_C() ^ 0xA210FE65F20017D6L);
        long factorA = random.nextLong() / 2L * 2L + 1L;
        long factorB = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)chunkX * factorA + (long)chunkZ * factorB ^ pocket.func_72905_C());
        do {
            int x = chunkX * 16 + random.nextInt(16);
            int z = chunkZ * 16 + random.nextInt(16);
            int y = 245;
            block = pocket.func_147439_a(x, y, z);
            while (block.isAir((IBlockAccess)pocket, x, y, z) && y > 0) {
                block = pocket.func_147439_a(x, --y, z);
            }
            while ((block == mod_pocketDim.blockDimWall || block == mod_pocketDim.blockDimWallPerm) && y > 0) {
                block = pocket.func_147439_a(x, --y, z);
            }
            while (block.isAir((IBlockAccess)pocket, x, y, z) && y > 0) {
                block = pocket.func_147439_a(x, --y, z);
            }
            if (y <= 0) continue;
            int jumpSanity = 0;
            int jumpHeight = 0;
            while (!pocket.func_147437_c(x, (jumpHeight = y + random.nextInt(10)) + 6, z) && ++jumpSanity < 20) {
            }
            MobMonolith monolith = new MobMonolith((World)pocket);
            monolith.func_70012_b(x, (float)jumpHeight - (5.0f - monolith.func_70603_bj() * 5.0f), z, 1.0f, 1.0f);
            pocket.func_72838_d((Entity)monolith);
            didSpawn = true;
        } while (++sanity < 5 && !didSpawn);
    }

    private void placeMonolithsInLimbo(World limbo, int chunkX, int chunkZ) {
        Random random = new Random(limbo.func_72905_C() ^ 0xB5130C4ACC71A822L);
        long factorA = random.nextLong() / 2L * 2L + 1L;
        long factorB = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)chunkX * factorA + (long)chunkZ * factorB ^ limbo.func_72905_C());
        if (random.nextInt(100) < this.properties.MonolithSpawningChance) {
            int yTest;
            int y = 0;
            do {
                int x = chunkX * 16 + random.nextInt(16);
                int z = chunkZ * 16 + random.nextInt(16);
                while (limbo.func_147439_a(x, y, z).isAir((IBlockAccess)limbo, x, y, z) && y < 255) {
                    ++y;
                }
                yTest = yCoordHelper.getFirstUncovered(limbo, x, (y = yCoordHelper.getFirstUncovered(limbo, x, y + 2, z)) + 5, z);
                if (yTest > 245) {
                    return;
                }
                int jumpSanity = 0;
                int jumpHeight = 0;
                while (!limbo.func_147437_c(x, (jumpHeight = y + random.nextInt(25)) + 6, z) && ++jumpSanity < 20) {
                }
                MobMonolith monolith = new MobMonolith(limbo);
                monolith.func_70012_b(x, jumpHeight, z, 1.0f, 1.0f);
                limbo.func_72838_d((Entity)monolith);
            } while (yTest > y);
        }
    }

    public static boolean isMobSpawningAllowed() {
        GameRules rules = MinecraftServer.func_71276_C().func_71218_a(0).func_82736_K();
        return rules.func_82766_b(MOB_SPAWNING_RULE);
    }
}

