/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.schematic;

import StevenDimDoors.mod_pocketDim.Point3D;
import net.minecraft.world.World;

public abstract class WorldOperation {
    private String name;

    public WorldOperation(String name) {
        this.name = name;
    }

    protected boolean initialize(World world, int x, int y, int z, int width, int height, int length) {
        return true;
    }

    protected abstract boolean applyToBlock(World var1, int var2, int var3, int var4);

    protected boolean finish() {
        return true;
    }

    public boolean apply(World world, Point3D minCorner, Point3D maxCorner) {
        int x = minCorner.getX();
        int y = minCorner.getY();
        int z = minCorner.getZ();
        int width = maxCorner.getX() - x + 1;
        int height = maxCorner.getY() - y + 1;
        int length = maxCorner.getZ() - z + 1;
        return this.apply(world, x, y, z, width, height, length);
    }

    public boolean apply(World world, int x, int y, int z, int width, int height, int length) {
        if (!this.initialize(world, x, y, z, width, height, length)) {
            return false;
        }
        int limitX = x + width;
        int limitY = y + height;
        int limitZ = z + length;
        for (int cy = y; cy < limitY; ++cy) {
            for (int cz = z; cz < limitZ; ++cz) {
                for (int cx = x; cx < limitX; ++cx) {
                    if (this.applyToBlock(world, cx, cy, cz)) continue;
                    return false;
                }
            }
        }
        return this.finish();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

