/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.schematic;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.schematic.ChunkBlockSetter;
import StevenDimDoors.mod_pocketDim.schematic.CompactBoundsOperation;
import StevenDimDoors.mod_pocketDim.schematic.IBlockSetter;
import StevenDimDoors.mod_pocketDim.schematic.InvalidSchematicException;
import StevenDimDoors.mod_pocketDim.schematic.SchematicFilter;
import StevenDimDoors.mod_pocketDim.schematic.WorldBlockSetter;
import StevenDimDoors.mod_pocketDim.schematic.WorldCopyOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Schematic {
    protected short width;
    protected short height;
    protected short length;
    protected Block[] blocks;
    protected byte[] metadata;
    protected NBTTagList tileEntities;

    protected Schematic(short width, short height, short length, String[] blockPalette, short[] blockIds, byte[] metadata, NBTTagList tileEntities) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.metadata = metadata;
        this.tileEntities = tileEntities;
        if (blockPalette != null) {
            this.loadBlockList(blockPalette, blockIds);
        }
    }

    protected Schematic(short width, short height, short length, Block[] blocks, byte[] metadata, NBTTagList tileEntities) {
        this.width = width;
        this.height = height;
        this.length = length;
        this.blocks = blocks;
        this.metadata = metadata;
        this.tileEntities = tileEntities;
    }

    protected Schematic(Schematic source) {
        this.width = source.width;
        this.height = source.height;
        this.length = source.length;
        this.blocks = source.blocks;
        this.metadata = source.metadata;
        this.tileEntities = source.tileEntities;
    }

    private void loadBlockList(String[] blockPalette, short[] blockIds) {
        int i;
        this.blocks = new Block[blockIds.length];
        Block[] blockObjPalette = new Block[blockPalette.length];
        for (i = 0; i < blockPalette.length; ++i) {
            blockObjPalette[i] = (Block)Block.field_149771_c.func_82594_a(blockPalette[i]);
        }
        for (i = 0; i < blockIds.length; ++i) {
            this.blocks[i] = blockObjPalette[blockIds[i]];
        }
    }

    public int calculateIndex(int x, int y, int z) {
        if (x < 0 || x >= this.width) {
            throw new IndexOutOfBoundsException("x must be non-negative and less than width");
        }
        if (y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("y must be non-negative and less than height");
        }
        if (z < 0 || z >= this.length) {
            throw new IndexOutOfBoundsException("z must be non-negative and less than length");
        }
        return y * this.width * this.length + z * this.width + x;
    }

    public Point3D calculatePoint(int index) {
        int y = index / (this.width * this.length);
        int z = (index -= y * this.width * this.length) / this.width;
        int x = index -= z * this.width;
        return new Point3D(x, y, z);
    }

    public int calculateIndexBelow(int index) {
        return index - this.width * this.length;
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public Block getBlock(int x, int y, int z) {
        return (Block)Block.field_149771_c.func_82594_a((Object)this.blocks[this.calculateIndex(x, y, z)]);
    }

    public byte getBlockMetadata(int x, int y, int z) {
        return this.metadata[this.calculateIndex(x, y, z)];
    }

    public NBTTagList getTileEntities() {
        return (NBTTagList)this.tileEntities.func_74737_b();
    }

    public static Schematic readFromFile(String schematicPath) throws FileNotFoundException, InvalidSchematicException {
        return Schematic.readFromFile(new File(schematicPath));
    }

    public static Schematic readFromFile(File schematicFile) throws FileNotFoundException, InvalidSchematicException {
        return Schematic.readFromStream(new FileInputStream(schematicFile));
    }

    public static Schematic readFromResource(String resourcePath) throws InvalidSchematicException {
        InputStream schematicStream = Schematic.class.getResourceAsStream(resourcePath);
        return Schematic.readFromStream(schematicStream);
    }

    public static Schematic readFromStream(InputStream schematicStream) throws InvalidSchematicException {
        byte[] metadata = null;
        byte[] lowBits = null;
        byte[] highBits = null;
        short[] blockIds = null;
        String[] blockPalette = null;
        NBTTagList tileEntities = null;
        try {
            int index;
            boolean hasExtendedBlockIDs;
            int i;
            NBTTagCompound schematicTag;
            try {
                schematicTag = CompressedStreamTools.func_74796_a((InputStream)schematicStream);
                schematicStream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new InvalidSchematicException("The schematic could not be decoded.");
            }
            short width = schematicTag.func_74765_d("Width");
            short height = schematicTag.func_74765_d("Height");
            short length = schematicTag.func_74765_d("Length");
            int volume = width * length * height;
            if (width < 0) {
                throw new InvalidSchematicException("The schematic cannot have a negative width.");
            }
            if (height < 0) {
                throw new InvalidSchematicException("The schematic cannot have a negative height.");
            }
            if (length < 0) {
                throw new InvalidSchematicException("The schematic cannot have a negative length.");
            }
            NBTTagList nbtPalette = schematicTag.func_150295_c("Palette", 8);
            if (nbtPalette.func_74745_c() < 1) {
                throw new InvalidSchematicException("The schematic must have a valid block palette.");
            }
            blockPalette = new String[nbtPalette.func_74745_c()];
            for (i = 0; i < nbtPalette.func_74745_c(); ++i) {
                blockPalette[i] = nbtPalette.func_150307_f(i);
            }
            lowBits = schematicTag.func_74770_j("Blocks");
            highBits = schematicTag.func_74770_j("AddBlocks");
            metadata = schematicTag.func_74770_j("Data");
            boolean bl = hasExtendedBlockIDs = highBits.length != 0;
            if (volume != lowBits.length) {
                throw new InvalidSchematicException("The schematic has data for fewer blocks than its dimensions indicate.");
            }
            if (volume != metadata.length) {
                throw new InvalidSchematicException("The schematic has metadata for fewer blocks than its dimensions indicate.");
            }
            if (volume > 2 * highBits.length && hasExtendedBlockIDs) {
                throw new InvalidSchematicException("The schematic has extended block IDs for fewer blocks than its dimensions indicate.");
            }
            blockIds = new short[volume];
            if (hasExtendedBlockIDs) {
                int pairs = volume - (volume & 1);
                for (index = 0; index < pairs; index += 2) {
                    blockIds[index] = (short)(((highBits[index >> 1] & 0xF) << 8) + (lowBits[index] & 0xFF));
                    blockIds[index + 1] = (short)(((highBits[index >> 1] & 0xF0) << 4) + (lowBits[index + 1] & 0xFF));
                }
                if (index < volume) {
                    blockIds[index] = lowBits[index >> 1];
                }
            } else {
                for (index = 0; index < volume; ++index) {
                    blockIds[index] = (short)(lowBits[index] & 0xFF);
                }
            }
            for (i = 0; i < blockIds.length; ++i) {
                short paletteIndex = blockIds[i];
                if (paletteIndex >= 0 && paletteIndex < blockPalette.length) continue;
                throw new InvalidSchematicException("Block entry referenced a non-existant palette entry.");
            }
            tileEntities = schematicTag.func_150295_c("TileEntities", 10);
            Schematic result = new Schematic(width, height, length, blockPalette, blockIds, metadata, tileEntities);
            return result;
        }
        catch (InvalidSchematicException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidSchematicException("An unexpected error occurred while trying to decode the schematic.", ex);
        }
    }

    public static Schematic copyFromWorld(World world, int x, int y, int z, short width, short height, short length, boolean doCompactBounds) {
        if (doCompactBounds) {
            int worldHeight;
            int fixedY = y < 0 ? 0 : y;
            int fixedHeight = height + y - fixedY;
            if (fixedHeight + fixedY >= (worldHeight = world.func_72800_K())) {
                fixedHeight = worldHeight - fixedY;
            }
            CompactBoundsOperation compactor = new CompactBoundsOperation();
            compactor.apply(world, x, fixedY, z, width, fixedHeight, length);
            Point3D minCorner = compactor.getMinCorner();
            Point3D maxCorner = compactor.getMaxCorner();
            short compactWidth = (short)(maxCorner.getX() - minCorner.getX() + 1);
            short compactHeight = (short)(maxCorner.getY() - minCorner.getY() + 1);
            short compactLength = (short)(maxCorner.getZ() - minCorner.getZ() + 1);
            return Schematic.copyFromWorld(world, minCorner.getX(), minCorner.getY(), minCorner.getZ(), compactWidth, compactHeight, compactLength);
        }
        return Schematic.copyFromWorld(world, x, y, z, width, height, length);
    }

    private static Schematic copyFromWorld(World world, int x, int y, int z, short width, short height, short length) {
        WorldCopyOperation copier = new WorldCopyOperation();
        copier.apply(world, x, y, z, width, height, length);
        return new Schematic(width, height, length, copier.getBlocks(), copier.getMetadata(), copier.getTileEntities());
    }

    private static boolean encodeBlockIDs(short[] blocks, byte[] lowBits, byte[] highBits) {
        int index;
        int length = blocks.length - (blocks.length & 1);
        boolean hasHighBits = false;
        for (index = 0; index < length; index += 2) {
            highBits[index >> 1] = (byte)((blocks[index] >> 8 & 0xF) + (blocks[index + 1] >> 4 & 0xF0));
            hasHighBits |= highBits[index >> 1] != 0;
        }
        if (index < blocks.length) {
            highBits[index >> 1] = (byte)(blocks[index] >> 8 & 0xF);
            hasHighBits |= highBits[index >> 1] != 0;
        }
        for (index = 0; index < blocks.length; ++index) {
            lowBits[index] = (byte)(blocks[index] & 0xFF);
        }
        return hasHighBits;
    }

    private static void reduceToPalette(Block[] blocks, List<String> blockPalette, short[] blockIds) {
        for (int i = 0; i < blocks.length; ++i) {
            String blockName = Block.field_149771_c.func_148750_c((Object)blocks[i]);
            int blockIndex = blockPalette.indexOf(blockName);
            if (blockIndex < 0) {
                blockIndex = blockPalette.size();
                blockPalette.add(blockName);
            }
            blockIds[i] = (short)blockIndex;
        }
    }

    public NBTTagCompound writeToNBT() {
        return this.writeToNBT(true);
    }

    protected NBTTagCompound writeToNBT(boolean copyTileEntities) {
        return Schematic.writeToNBT(this.width, this.height, this.length, this.blocks, this.metadata, this.tileEntities, copyTileEntities);
    }

    protected static NBTTagCompound writeToNBT(short width, short height, short length, Block[] blocks, byte[] metadata, NBTTagList tileEntities, boolean copyTileEntities) {
        NBTTagCompound schematicTag = new NBTTagCompound();
        schematicTag.func_74777_a("Width", width);
        schematicTag.func_74777_a("Length", length);
        schematicTag.func_74777_a("Height", height);
        schematicTag.func_74782_a("Entities", (NBTBase)new NBTTagList());
        schematicTag.func_74778_a("Materials", "Alpha");
        LinkedList<String> blockPalette = new LinkedList<String>();
        short[] blockIds = new short[blocks.length];
        Schematic.reduceToPalette(blocks, blockPalette, blockIds);
        byte[] lowBits = new byte[blocks.length];
        byte[] highBits = new byte[(blocks.length >> 1) + (blocks.length & 1)];
        boolean hasExtendedIDs = Schematic.encodeBlockIDs(blockIds, lowBits, highBits);
        schematicTag.func_74773_a("Blocks", lowBits);
        schematicTag.func_74773_a("Data", metadata);
        if (hasExtendedIDs) {
            schematicTag.func_74773_a("AddBlocks", highBits);
        }
        if (copyTileEntities) {
            schematicTag.func_74782_a("TileEntities", tileEntities.func_74737_b());
        } else {
            schematicTag.func_74782_a("TileEntities", (NBTBase)tileEntities);
        }
        return schematicTag;
    }

    public void writeToFile(String schematicPath) throws IOException {
        this.writeToFile(new File(schematicPath));
    }

    public void writeToFile(File schematicFile) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(schematicFile);
        CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(false), (OutputStream)outputStream);
        outputStream.close();
    }

    public boolean applyFilter(SchematicFilter filter) {
        return filter.apply(this, this.blocks, this.metadata);
    }

    public void copyToWorld(World world, int x, int y, int z, boolean notifyClients, boolean ignoreAir) {
        if (notifyClients) {
            this.copyToWorld(world, x, y, z, new WorldBlockSetter(false, true, ignoreAir));
        } else {
            this.copyToWorld(world, x, y, z, new ChunkBlockSetter(ignoreAir));
        }
    }

    protected void copyToWorld(World world, int x, int y, int z, IBlockSetter blockSetter) {
        int dx;
        int dz;
        int dy;
        int index = 0;
        for (dy = 0; dy < this.height; ++dy) {
            for (dz = 0; dz < this.length; ++dz) {
                for (dx = 0; dx < this.width; ++dx) {
                    blockSetter.setBlock(world, x + dx, y + dy, z + dz, this.blocks[index], this.metadata[index]);
                    ++index;
                }
            }
        }
        int count = this.tileEntities.func_74745_c();
        for (index = 0; index < count; ++index) {
            NBTTagCompound tileTag = this.tileEntities.func_150305_b(index);
            dx = tileTag.func_74762_e("x") + x;
            dy = tileTag.func_74762_e("y") + y;
            dz = tileTag.func_74762_e("z") + z;
            tileTag.func_74768_a("x", dx);
            tileTag.func_74768_a("y", dy);
            tileTag.func_74768_a("z", dz);
            world.func_147455_a(dx, dy, dz, TileEntity.func_145827_c((NBTTagCompound)tileTag));
        }
    }
}

