/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.saving;

import StevenDimDoors.mod_pocketDim.DimData;
import StevenDimDoors.mod_pocketDim.LinkData;
import StevenDimDoors.mod_pocketDim.ObjectSaveInputStream;
import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.saving.DDSaveHandler;
import StevenDimDoors.mod_pocketDim.saving.PackedDimData;
import StevenDimDoors.mod_pocketDim.saving.PackedLinkData;
import StevenDimDoors.mod_pocketDim.saving.PackedLinkTail;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OldSaveImporter {
    public static void importOldSave(File file) throws IOException, ClassNotFoundException {
        HashMap dimMap;
        FileInputStream saveFile = new FileInputStream(file);
        ObjectSaveInputStream save = new ObjectSaveInputStream(saveFile);
        HashMap comboSave = (HashMap)save.readObject();
        save.close();
        ArrayList<PackedLinkData> allPackedLinks = new ArrayList<PackedLinkData>();
        HashMap<Integer, PackedDimData> newPackedDimData = new HashMap<Integer, PackedDimData>();
        try {
            dimMap = (HashMap)comboSave.get("dimList");
        }
        catch (Exception e) {
            System.out.println("Could not import old save data");
            return;
        }
        HashMap parentChildMapping = new HashMap();
        for (DimData data : dimMap.values()) {
            if (!data.isPocket) continue;
            LinkData link = data.exitDimLink;
            if (parentChildMapping.containsKey(link.destDimID)) {
                ((ArrayList)parentChildMapping.get(link.destDimID)).add(data.dimID);
            } else {
                parentChildMapping.put(link.destDimID, new ArrayList());
                ((ArrayList)parentChildMapping.get(link.destDimID)).add(data.dimID);
            }
            parentChildMapping.remove(data.dimID);
        }
        for (DimData data : dimMap.values()) {
            ArrayList<PackedLinkData> newPackedLinkData = new ArrayList<PackedLinkData>();
            List childDims = parentChildMapping.containsKey(data.dimID) ? (List)parentChildMapping.get(data.dimID) : new ArrayList();
            for (LinkData link : data.getLinksInDim()) {
                Point4D source = new Point4D(link.locXCoord, link.locYCoord, link.locZCoord, link.locDimID);
                Point4D destintion = new Point4D(link.destXCoord, link.destYCoord, link.destZCoord, link.destDimID);
                PackedLinkTail tail = new PackedLinkTail(destintion, LinkType.NORMAL);
                ArrayList<Point3D> children = new ArrayList<Point3D>();
                PackedLinkData newPackedLink = new PackedLinkData(source, new Point3D(-1, -1, -1), tail, link.linkOrientation, children, null);
                newPackedLinkData.add(newPackedLink);
                allPackedLinks.add(newPackedLink);
            }
            DimensionType type = data.isPocket ? (data.dungeonGenerator != null ? DimensionType.DUNGEON : DimensionType.POCKET) : DimensionType.ROOT;
            PackedDimData dim = data.isPocket ? new PackedDimData(data.dimID, data.depth, data.depth, data.exitDimLink.locDimID, data.exitDimLink.locDimID, 0, type, data.hasBeenFilled, null, new Point3D(0, 64, 0), childDims, newPackedLinkData, null) : new PackedDimData(data.dimID, data.depth, data.depth, data.dimID, data.dimID, 0, type, data.hasBeenFilled, null, new Point3D(0, 64, 0), childDims, newPackedLinkData, null);
            newPackedDimData.put(dim.ID, dim);
        }
        DDSaveHandler.unpackDimData(newPackedDimData);
        DDSaveHandler.unpackLinkData(allPackedLinks);
    }
}

