/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.saving;

import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.saving.PackedDimData;
import StevenDimDoors.mod_pocketDim.util.BaseConfigurationProcessor;
import StevenDimDoors.mod_pocketDim.util.ConfigurationProcessingException;
import StevenDimDoors.mod_pocketDim.util.JSONValidator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;

public class DimDataProcessor
extends BaseConfigurationProcessor<PackedDimData> {
    public final String JSON_VERSION_PROPERTY_NAME = "SAVE_DATA_VERSION_ID_INSTANCE";
    private HashMap<Integer, JsonObject> SAVE_DATA_SCHEMA = new HashMap();
    private static final JsonParser jsonParser = new JsonParser();
    public static final String BASE_SCHEMA_PATH = "/assets/dimdoors/text/";

    public DimDataProcessor() {
        this.SAVE_DATA_SCHEMA.put(982405775, this.loadSchema("/assets/dimdoors/text/Dim_Data_Schema_v982405775.json"));
        this.SAVE_DATA_SCHEMA.put(100, this.loadSchema("/assets/dimdoors/text/Dim_Data_Schema_v1-0-0.json"));
    }

    @Override
    public PackedDimData readFromStream(InputStream inputStream) throws ConfigurationProcessingException {
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
            PackedDimData data = this.readDimDataJson(reader);
            reader.close();
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationProcessingException("Could not read packedDimData");
        }
    }

    @Override
    public void writeToStream(OutputStream outputStream, PackedDimData data) throws ConfigurationProcessingException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        JsonElement ele = gson.toJsonTree((Object)data);
        try {
            JSONValidator.validate(this.getSaveDataSchema(ele.getAsJsonObject()), ele);
            outputStream.write(gson.toJson(ele).getBytes("UTF-8"));
            outputStream.close();
        }
        catch (Exception e) {
            throw new ConfigurationProcessingException("Could not access save data");
        }
    }

    public PackedDimData readDimDataJson(JsonReader reader) throws IOException {
        JsonElement ele = jsonParser.parse(reader);
        JsonObject schema = this.getSaveDataSchema(ele.getAsJsonObject());
        JSONValidator.validate(schema, ele);
        ele = this.processSaveData(schema, ele.getAsJsonObject());
        GsonBuilder gsonBuilder = new GsonBuilder();
        return (PackedDimData)gsonBuilder.create().fromJson(ele, PackedDimData.class);
    }

    public JsonObject getSaveDataSchema(JsonObject obj) {
        JsonObject schema = this.SAVE_DATA_SCHEMA.get(obj.get("SAVE_DATA_VERSION_ID_INSTANCE").getAsInt());
        if (schema == null) {
            throw new IllegalStateException("Invalid save data version");
        }
        return schema;
    }

    private JsonObject loadSchema(String path) {
        InputStream in = this.getClass().getResourceAsStream(path);
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(in));
        JsonObject schema = jsonParser.parse(reader).getAsJsonObject();
        try {
            reader.close();
            in.close();
        }
        catch (IOException e) {
            System.err.println("Could not load Json Save Data definitions");
            e.printStackTrace();
            throw new IllegalStateException("Could not load Json Save Data definitions");
        }
        return schema;
    }

    public JsonObject processSaveData(JsonObject schema, JsonObject save) {
        int incomingSaveVersionID = save.get("SAVE_DATA_VERSION_ID_INSTANCE").getAsInt();
        if (incomingSaveVersionID == 100) {
            JSONValidator.validate(this.getSaveDataSchema(save), (JsonElement)save);
            return save;
        }
        if (incomingSaveVersionID == 982405775) {
            DimensionType type = save.get("RootID").getAsInt() != save.get("ID").getAsInt() ? (save.get("IsDungeon").getAsBoolean() ? DimensionType.DUNGEON : DimensionType.POCKET) : DimensionType.ROOT;
            save.remove("IsDungeon");
            save.addProperty("DimensionType", (Number)type.index);
            save.remove(this.JSON_VERSION_PROPERTY_NAME);
            save.addProperty(this.JSON_VERSION_PROPERTY_NAME, (Number)100);
        }
        return this.processSaveData(this.getSaveDataSchema(save), save);
    }
}

