/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.saving;

import StevenDimDoors.mod_pocketDim.Point3D;
import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.DimensionType;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.dungeon.DungeonData;
import StevenDimDoors.mod_pocketDim.helpers.DungeonHelper;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import StevenDimDoors.mod_pocketDim.saving.BlacklistProcessor;
import StevenDimDoors.mod_pocketDim.saving.DimDataProcessor;
import StevenDimDoors.mod_pocketDim.saving.IPackable;
import StevenDimDoors.mod_pocketDim.saving.PackedDimData;
import StevenDimDoors.mod_pocketDim.saving.PackedDungeonData;
import StevenDimDoors.mod_pocketDim.saving.PackedLinkData;
import StevenDimDoors.mod_pocketDim.saving.PersonalPocketMappingProcessor;
import StevenDimDoors.mod_pocketDim.util.DDLogger;
import StevenDimDoors.mod_pocketDim.util.FileFilters;
import StevenDimDoors.mod_pocketDim.util.Point4D;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;

public class DDSaveHandler {
    public static boolean loadAll() {
        File[] dataFiles;
        DDLogger.startTimer("Loading data");
        String basePath = DimensionManager.getCurrentSaveRootDirectory() + "/DimensionalDoors/data/";
        File dataDirectory = new File(basePath);
        if (!dataDirectory.exists()) {
            return true;
        }
        File blacklistFile = new File(basePath + "blacklist.txt");
        if (blacklistFile.exists()) {
            BlacklistProcessor blacklistReader = new BlacklistProcessor();
            List<Integer> blacklist = DDSaveHandler.readBlacklist(blacklistFile, blacklistReader);
            PocketManager.createAndRegisterBlacklist(blacklist);
        }
        File personalPocketMap = new File(basePath + "personalPockets.txt");
        HashMap<Object, Object> ppMap = new HashMap();
        if (personalPocketMap.exists()) {
            PersonalPocketMappingProcessor ppMappingProcessor = new PersonalPocketMappingProcessor();
            ppMap = DDSaveHandler.readPersonalPocketsMapping(personalPocketMap, ppMappingProcessor);
        }
        DimDataProcessor reader = new DimDataProcessor();
        HashMap<Integer, PackedDimData> packedDims = new HashMap<Integer, PackedDimData>();
        FileFilters.RegexFileFilter dataFileFilter = new FileFilters.RegexFileFilter("dim_-?\\d+\\.txt");
        for (File dataFile : dataFiles = dataDirectory.listFiles(dataFileFilter)) {
            PackedDimData packedDim = DDSaveHandler.readDimension(dataFile, reader);
            if (packedDim == null) {
                throw new IllegalStateException("The DD data for " + dataFile.getName().replace(".txt", "") + " at " + dataFile.getPath() + " is corrupted. Please report this on the MCF or on the DD github issues tracker.");
            }
            packedDims.put(packedDim.ID, packedDim);
        }
        ArrayList<PackedLinkData> linksToUnpack = new ArrayList<PackedLinkData>();
        for (PackedDimData packedDim : packedDims.values()) {
            linksToUnpack.addAll(packedDim.Links);
        }
        DDSaveHandler.unpackDimData(packedDims);
        DDSaveHandler.unpackLinkData(linksToUnpack);
        HashMap<String, NewDimData> personalPocketsMap = new HashMap<String, NewDimData>();
        for (Map.Entry<Object, Object> pair : ppMap.entrySet()) {
            personalPocketsMap.put((String)pair.getKey(), PocketManager.getDimensionData((Integer)pair.getValue()));
        }
        PocketManager.setPersonalPocketsMapping(personalPocketsMap);
        return true;
    }

    public static boolean unpackDimData(HashMap<Integer, PackedDimData> packedDims) {
        LinkedList<Integer> dimsToRegister = new LinkedList<Integer>();
        for (PackedDimData packedDim : packedDims.values()) {
            DDSaveHandler.verifyParents(packedDim, packedDims);
            if (packedDim.RootID != packedDim.ID) continue;
            dimsToRegister.addFirst(packedDim.ID);
        }
        while (!dimsToRegister.isEmpty()) {
            Integer childID = (Integer)dimsToRegister.pop();
            PackedDimData data = packedDims.get(childID);
            dimsToRegister.addAll(DDSaveHandler.verifyChildren(data, packedDims));
            PocketManager.registerPackedDimData(data);
        }
        return true;
    }

    private static ArrayList<Integer> verifyChildren(PackedDimData packedDim, HashMap<Integer, PackedDimData> packedDims) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        children.addAll(packedDim.ChildIDs);
        boolean isMissing = false;
        for (Integer childID : packedDim.ChildIDs) {
            if (packedDims.containsKey(childID)) continue;
            children.remove(childID);
            isMissing = true;
        }
        if (isMissing) {
            packedDim = new PackedDimData(packedDim.ID, packedDim.Depth, packedDim.PackDepth, packedDim.ParentID, packedDim.RootID, packedDim.Orientation, DimensionType.getTypeFromIndex(packedDim.DimensionType), packedDim.IsFilled, packedDim.DungeonData, packedDim.Origin, children, packedDim.Links, packedDim.Tails);
            packedDims.put(packedDim.ID, packedDim);
        }
        return children;
    }

    public static void verifyParents(PackedDimData packedDim, HashMap<Integer, PackedDimData> packedDims) {
        ArrayList<Integer> fosterChildren = new ArrayList<Integer>();
        fosterChildren.add(packedDim.ID);
        DimensionType type = DimensionType.getTypeFromIndex(packedDim.DimensionType);
        if (!packedDims.containsKey(packedDim.ParentID)) {
            packedDim = new PackedDimData(packedDim.ID, 1, packedDim.PackDepth, packedDim.RootID, packedDim.RootID, packedDim.Orientation, type, packedDim.IsFilled, packedDim.DungeonData, packedDim.Origin, packedDim.ChildIDs, packedDim.Links, packedDim.Tails);
            packedDims.put(packedDim.ID, packedDim);
        }
        PackedDimData fosterParent = packedDims.get(packedDim.ParentID);
        if (!fosterParent.ChildIDs.contains(packedDim.ID) && packedDim.ID != packedDim.RootID) {
            fosterChildren.addAll(fosterParent.ChildIDs);
            fosterParent = new PackedDimData(fosterParent.ID, fosterParent.Depth, fosterParent.PackDepth, fosterParent.ParentID, fosterParent.RootID, fosterParent.Orientation, type, fosterParent.IsFilled, fosterParent.DungeonData, fosterParent.Origin, fosterChildren, fosterParent.Links, fosterParent.Tails);
            packedDims.put(fosterParent.ID, fosterParent);
        }
    }

    public static boolean unpackLinkData(List<PackedLinkData> linksToUnpack) {
        NewDimData data;
        Point3D fakePoint = new Point3D(-1, -1, -1);
        ArrayList<PackedLinkData> unpackedLinks = new ArrayList<PackedLinkData>();
        for (PackedLinkData packedLink : linksToUnpack) {
            if (!packedLink.parent.equals(fakePoint)) continue;
            data = PocketManager.getDimensionData(packedLink.source.getDimension());
            LinkType linkType = LinkType.getLinkTypeFromIndex(packedLink.tail.linkType);
            DimLink link = data.createLink(packedLink.source, linkType, packedLink.orientation, packedLink.lock);
            Point4D destination = packedLink.tail.destination;
            if (destination != null) {
                PocketManager.createDimensionDataDangerously(destination.getDimension()).setLinkDestination(link, destination.getX(), destination.getY(), destination.getZ());
            }
            unpackedLinks.add(packedLink);
        }
        linksToUnpack.removeAll(unpackedLinks);
        while (!linksToUnpack.isEmpty()) {
            for (PackedLinkData packedLink : linksToUnpack) {
                data = PocketManager.createDimensionDataDangerously(packedLink.source.getDimension());
                if (data.getLink(packedLink.parent) != null) {
                    data.createChildLink(packedLink.source, data.getLink(packedLink.parent), packedLink.lock);
                }
                unpackedLinks.add(packedLink);
            }
            linksToUnpack.removeAll(unpackedLinks);
        }
        return true;
    }

    private static PackedDimData readDimension(File dataFile, DimDataProcessor reader) {
        try {
            return (PackedDimData)reader.readFromFile(dataFile);
        }
        catch (Exception e) {
            System.err.println("Could not read dimension data from: " + dataFile.getAbsolutePath());
            System.err.println("The following error occurred:");
            DDSaveHandler.printException(e, false);
            return null;
        }
    }

    public static boolean saveAll(Iterable<? extends IPackable<PackedDimData>> dimensions, List<Integer> blacklist, boolean checkModified) throws IOException {
        File saveDirectory = new File(mod_pocketDim.instance.getCurrentSavePath() + "/DimensionalDoors/data/");
        String savePath = saveDirectory.getAbsolutePath();
        String baseSavePath = savePath + "/dim_";
        File backupDirectory = new File(savePath + "/backup");
        String baseBackupPath = backupDirectory.getAbsolutePath() + "/dim_";
        if (!saveDirectory.exists()) {
            Files.createParentDirs((File)saveDirectory);
            saveDirectory.mkdir();
        }
        if (!backupDirectory.exists()) {
            backupDirectory.mkdir();
        }
        DDSaveHandler.writeBlacklist(blacklist, savePath);
        DDSaveHandler.writePersonalPocketMap(PocketManager.getPersonalPocketMapping(), savePath);
        boolean succeeded = true;
        DimDataProcessor writer = new DimDataProcessor();
        for (IPackable<PackedDimData> iPackable : dimensions) {
            if (checkModified && !iPackable.isModified()) continue;
            if (DDSaveHandler.writeDimension(iPackable, writer, baseSavePath, baseBackupPath)) {
                iPackable.clearModified();
                continue;
            }
            succeeded = false;
        }
        return succeeded;
    }

    private static boolean writeBlacklist(List<Integer> blacklist, String savePath) {
        try {
            BlacklistProcessor writer = new BlacklistProcessor();
            File tempFile = new File(savePath + "/blacklist.tmp");
            File saveFile = new File(savePath + "/blacklist.txt");
            writer.writeToFile(tempFile, blacklist);
            saveFile.delete();
            tempFile.renameTo(saveFile);
            return true;
        }
        catch (Exception e) {
            System.err.println("Could not save blacklist. The following error occurred:");
            DDSaveHandler.printException(e, true);
            return false;
        }
    }

    private static boolean writePersonalPocketMap(HashMap<String, NewDimData> hashMap, String savePath) {
        try {
            HashMap<String, Integer> ppMap = new HashMap<String, Integer>();
            for (Map.Entry<String, NewDimData> pair : hashMap.entrySet()) {
                ppMap.put(pair.getKey(), pair.getValue().id());
            }
            PersonalPocketMappingProcessor writer = new PersonalPocketMappingProcessor();
            File tempFile = new File(savePath + "/personalPockets.tmp");
            File saveFile = new File(savePath + "/personalPockets.txt");
            writer.writeToFile(tempFile, ppMap);
            saveFile.delete();
            tempFile.renameTo(saveFile);
            return true;
        }
        catch (Exception e) {
            System.err.println("Could not save personal pockets mapping. The following error occurred:");
            DDSaveHandler.printException(e, true);
            return false;
        }
    }

    private static boolean writeDimension(IPackable<PackedDimData> dimension, DimDataProcessor writer, String basePath, String backupPath) {
        try {
            File saveFile = new File(basePath + dimension.name() + ".txt");
            if (saveFile.exists()) {
                Files.move((File)saveFile, (File)new File(backupPath + dimension.name() + ".txt"));
            }
            writer.writeToFile(saveFile, dimension.pack());
            return true;
        }
        catch (Exception e) {
            System.err.println("Could not save data for dimension #" + dimension.name() + ". The following error occurred:");
            DDSaveHandler.printException(e, true);
            return false;
        }
    }

    private static void printException(Exception e, boolean verbose) {
        if (e.getCause() == null) {
            if (verbose) {
                e.printStackTrace();
            } else {
                System.err.println(e.getMessage());
            }
        } else {
            System.out.println(e.getMessage());
            System.err.println("Caused by an underlying error:");
            if (verbose) {
                e.getCause().printStackTrace();
            } else {
                System.err.println(e.getCause().getMessage());
            }
        }
    }

    public static DungeonData unpackDungeonData(PackedDungeonData packedDungeon) {
        for (DungeonData data : DungeonHelper.instance().getRegisteredDungeons()) {
            if (!data.schematicName().equals(packedDungeon.SchematicName)) continue;
            return data;
        }
        return null;
    }

    public static List<Integer> readBlacklist(File blacklistFile, BlacklistProcessor reader) {
        try {
            List list = (List)reader.readFromFile(blacklistFile);
            if (list == null) {
                return new ArrayList<Integer>(0);
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<Integer>(0);
        }
    }

    public static HashMap<String, Integer> readPersonalPocketsMapping(File ppMap, PersonalPocketMappingProcessor reader) {
        try {
            return (HashMap)reader.readFromFile(ppMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

