/*
 * Decompiled with CFR 0.152.
 */
package StevenDimDoors.mod_pocketDim.items;

import StevenDimDoors.mod_pocketDim.core.DimLink;
import StevenDimDoors.mod_pocketDim.core.LinkType;
import StevenDimDoors.mod_pocketDim.core.NewDimData;
import StevenDimDoors.mod_pocketDim.core.PocketManager;
import StevenDimDoors.mod_pocketDim.items.ItemRiftSignature;
import StevenDimDoors.mod_pocketDim.mod_pocketDim;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemStabilizedRiftSignature
extends ItemRiftSignature {
    @Override
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = par1IconRegister.func_94245_a("dimdoors:" + this.func_77658_a().replace("item.", ""));
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        int adjustedY = ItemStabilizedRiftSignature.adjustYForSpecialBlocks(world, x, y + 2, z);
        if (!player.func_82247_a(x, adjustedY, z, side, stack)) {
            return true;
        }
        int orientation = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 4.0f / 360.0f) - 0.5)) & 3;
        ItemRiftSignature.Point4DOrientation source = ItemStabilizedRiftSignature.getSource(stack);
        if (source != null) {
            NewDimData sourceDimension = PocketManager.getDimensionData(source.getDimension());
            NewDimData destinationDimension = PocketManager.createDimensionData(world);
            DimLink reverse = destinationDimension.getLink(x, adjustedY, z);
            if (reverse != null && source.getPoint().equals(reverse.destination())) {
                DimLink link = sourceDimension.createLink(source.getX(), source.getY(), source.getZ(), LinkType.NORMAL, source.getOrientation());
                destinationDimension.setLinkDestination(link, x, adjustedY, z);
            } else {
                if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_146026_a(Items.field_151079_bi)) {
                    mod_pocketDim.sendChat(player, "You don't have any Ender Pearls!");
                    return true;
                }
                DimLink link = sourceDimension.createLink(source.getX(), source.getY(), source.getZ(), LinkType.NORMAL, source.getOrientation());
                reverse = destinationDimension.createLink(x, adjustedY, z, LinkType.NORMAL, orientation);
                destinationDimension.setLinkDestination(link, x, adjustedY, z);
                sourceDimension.setLinkDestination(reverse, source.getX(), source.getY(), source.getZ());
                mod_pocketDim.blockRift.tryPlacingRift(world, x, adjustedY, z);
            }
            WorldServer sourceWorld = DimensionManager.getWorld((int)sourceDimension.id());
            mod_pocketDim.blockRift.tryPlacingRift((World)sourceWorld, source.getX(), source.getY(), source.getZ());
            mod_pocketDim.sendChat(player, "Rift Created");
            world.func_72956_a((Entity)player, "mods.DimDoors.sfx.riftEnd", 0.6f, 1.0f);
        } else {
            ItemStabilizedRiftSignature.setSource(stack, x, adjustedY, z, orientation, PocketManager.createDimensionData(world));
            mod_pocketDim.sendChat(player, "Location Stored in Stabilized Rift Signature");
            world.func_72956_a((Entity)player, "mods.DimDoors.sfx.riftStart", 0.6f, 1.0f);
        }
        return true;
    }

    public static boolean useFromDispenser(ItemStack stack, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        int adjustedY = ItemStabilizedRiftSignature.adjustYForSpecialBlocks(world, x, y + 2, z);
        ItemRiftSignature.Point4DOrientation source = ItemStabilizedRiftSignature.getSource(stack);
        if (source != null) {
            NewDimData sourceDimension = PocketManager.getDimensionData(source.getDimension());
            NewDimData destinationDimension = PocketManager.createDimensionData(world);
            DimLink reverse = destinationDimension.getLink(x, adjustedY, z);
            if (reverse != null && source.getPoint().equals(reverse.destination())) {
                DimLink link = sourceDimension.createLink(source.getX(), source.getY(), source.getZ(), LinkType.NORMAL, source.getOrientation());
                destinationDimension.setLinkDestination(link, x, adjustedY, z);
                WorldServer sourceWorld = DimensionManager.getWorld((int)sourceDimension.id());
                mod_pocketDim.blockRift.tryPlacingRift((World)sourceWorld, source.getX(), source.getY(), source.getZ());
                world.func_72908_a((double)x + 0.5, (double)adjustedY + 0.5, (double)z + 0.5, "mods.DimDoors.sfx.riftEnd", 0.6f, 1.0f);
                return true;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        ItemRiftSignature.Point4DOrientation source = ItemStabilizedRiftSignature.getSource(par1ItemStack);
        if (source != null) {
            String text = StatCollector.func_74837_a((String)"info.riftSignature.bound", (Object[])new Object[]{source.getX(), source.getY(), source.getZ(), source.getDimension()});
            par3List.add(text);
        } else {
            mod_pocketDim.translateAndAdd("info.riftSignature.stable", par3List);
        }
    }
}

